/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.passive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.passive.PassiveSkill;

public class InnerGrowthSkill
extends PassiveSkill {
    private float strength = 2.0f;

    public InnerGrowthSkill(SkillBuilder<? extends PassiveSkill> builder) {
        super(builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(String.format("%.2f", Float.valueOf(this.strength * 20.0f)));
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        int blast = 0;
        for (ItemStack ArmorPiece : ((Player)container.getExecutor().getOriginal()).m_6168_()) {
            blast += ArmorPiece.getEnchantmentLevel(Enchantments.f_44968_);
        }
        this.strength = 0.1f + (float)blast / 200.0f;
        String string = String.valueOf(this.strength * 20.0f) + "/s";
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.drawString(gui.getFont(), string, x + 13.0f - (float)(gui.getFont().m_92895_(string) / 2), y + 10.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient()) {
            int blast = 0;
            for (ItemStack ArmorPiece : ((Player)container.getExecutor().getOriginal()).m_6168_()) {
                blast += ArmorPiece.getEnchantmentLevel(Enchantments.f_44968_);
            }
            this.strength = 0.1f + (float)blast / 200.0f;
            SkillContainer innateSkill = container.getExecutor().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
            if (innateSkill != null && innateSkill.getSkill() != null && innateSkill.getStack() < innateSkill.getSkill().getMaxStack()) {
                innateSkill.getSkill().setConsumptionSynchronize(innateSkill, innateSkill.getResource() + this.strength);
            }
        }
    }
}

