/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponinnate;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import reascer.wom.animation.dodges.CancelableDodgeAnimation;
import reascer.wom.gameasset.animations.weapons.AnimsAgony;
import reascer.wom.skill.WOMSkillDataKeys;
import reascer.wom.world.damagesources.WOMExtraDamageInstance;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.DodgeAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillCastEvent;

public class SkyDiveSkill
extends WeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("c7a0ee46-56b3-4008-9fba-d2594b1e2676");
    public static final AnimationManager.AnimationAccessor[] AirCombo = new AnimationManager.AnimationAccessor[]{AnimsAgony.AGONY_AIR_ATTACK_1, AnimsAgony.AGONY_AIR_ATTACK_2, AnimsAgony.AGONY_AIR_ATTACK_3, AnimsAgony.AGONY_AIR_ATTACK_4, AnimsAgony.AGONY_RIPPING_FANGS};

    public SkyDiveSkill(SkillBuilder<? extends WeaponInnateSkill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            if (event.getDamageSource().getAnimation().equals(AnimsAgony.AGONY_SKY_DIVE) && event.getTarget() != ((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()) {
                int stack = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get());
                event.getDamageSource().addExtraDamage(WOMExtraDamageInstance.WOM_FLAT_DAMAGE.create(new float[]{(float)(stack * stack) * 0.5f}));
                if (stack > 1) {
                    event.getDamageSource().addExtraDamage(WOMExtraDamageInstance.WOM_TARGET_CURRENT_HEALTH.create(new float[]{(float)stack / 3.0f}));
                }
                ((Player)container.getExecutor().getOriginal()).m_183634_();
            }
            if (!event.getTarget().m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
                ServerPlayerPatch executer = (ServerPlayerPatch)event.getPlayerPatch();
                BlockPos ground = ((ServerPlayer)executer.getOriginal()).m_20183_();
                while (((ServerPlayer)executer.getOriginal()).m_9236_().m_8055_(ground).m_60713_(Blocks.f_50016_)) {
                    ground = ground.m_7495_();
                }
                if (((ServerPlayer)executer.getOriginal()).m_20186_() - (double)ground.m_123342_() > 4.0 && !event.getDamageSource().getAnimation().equals(AnimsAgony.AGONY_RIPPING_FANGS) && !event.getDamageSource().getAnimation().equals(AnimsAgony.AGONY_SKY_DIVE) && !event.getDamageSource().getAnimation().equals(AnimsAgony.AGONY_SKY_DIVE_X)) {
                    ((ServerPlayer)executer.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19620_, 8, 2, true, false, false));
                    ((ServerPlayer)executer.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19591_, 20, 2, true, false, false));
                    event.getTarget().m_7292_(new MobEffectInstance(MobEffects.f_19620_, 5, 4, true, false, false));
                    event.getTarget().m_7292_(new MobEffectInstance(MobEffects.f_19591_, 20, 2, true, false, false));
                }
                if (event.getDamageSource().getAnimation().equals(AnimsAgony.AGONY_RIPPING_FANGS)) {
                    if (event.getTarget().m_21023_(MobEffects.f_19591_)) {
                        event.getTarget().m_21195_(MobEffects.f_19591_);
                    }
                    if (event.getTarget().m_21023_(MobEffects.f_19620_)) {
                        event.getTarget().m_21195_(MobEffects.f_19620_);
                    }
                    if (((ServerPlayer)executer.getOriginal()).m_21023_(MobEffects.f_19591_)) {
                        ((ServerPlayer)executer.getOriginal()).m_21195_(MobEffects.f_19591_);
                    }
                    if (((ServerPlayer)executer.getOriginal()).m_21023_(MobEffects.f_19620_)) {
                        ((ServerPlayer)executer.getOriginal()).m_21195_(MobEffects.f_19620_);
                    }
                    ((ServerPlayer)executer.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19591_, 2, 0, true, false, false));
                    event.getTarget().m_6027_(event.getTarget().m_20185_() + ((ServerPlayer)executer.getOriginal()).m_20184_().f_82479_ * 5.0, Math.max(((ServerPlayer)executer.getOriginal()).m_20186_() - 0.5, (double)ground.m_7494_().m_123342_()), event.getTarget().m_20189_() + ((ServerPlayer)executer.getOriginal()).m_20184_().f_82481_ * 5.0);
                }
                if (((ServerPlayer)executer.getOriginal()).m_20186_() - (double)ground.m_123342_() > 1.0 && (event.getDamageSource().getAnimation().equals(AnimsAgony.AGONY_SKY_DIVE) || event.getDamageSource().getAnimation().equals(AnimsAgony.AGONY_SKY_DIVE_X))) {
                    if (event.getDamageSource().getAnimation().equals(AnimsAgony.AGONY_SKY_DIVE_X)) {
                        event.getTarget().m_6027_(event.getTarget().m_20185_(), (double)(ground.m_123342_() + 1), event.getTarget().m_20189_());
                    } else {
                        event.getTarget().m_6027_(event.getTarget().m_20185_(), (double)ground.m_123342_(), event.getTarget().m_20189_());
                    }
                }
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID, event -> {
            ServerPlayerPatch executer = (ServerPlayerPatch)event.getPlayerPatch();
            BlockPos ground = ((ServerPlayer)executer.getOriginal()).m_20183_();
            while (((ServerPlayer)executer.getOriginal()).m_9236_().m_8055_(ground).m_60713_(Blocks.f_50016_)) {
                ground = ground.m_7495_();
            }
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue()) {
                event.setCanceled(true);
                if (((ServerPlayer)executer.getOriginal()).m_6047_()) {
                    executer.playAnimationSynchronized((AssetAccessor)AirCombo[AirCombo.length - 1], 0.0f);
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ATTACKS.get(), (Object)0);
                } else {
                    int attack = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ATTACKS.get());
                    executer.playAnimationSynchronized((AssetAccessor)AirCombo[attack], 0.0f);
                    if (attack < 4) {
                        container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ATTACKS.get(), (Object)(++attack));
                    } else {
                        container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ATTACKS.get(), (Object)0);
                        executer.getSkill((SkillSlot)SkillSlots.BASIC_ATTACK).getDataManager().setDataSync((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get(), (Object)3);
                    }
                }
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (event.getAnimation().equals(AnimsAgony.AGONY_RISING_EAGLE)) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ATTACKS.get(), (Object)0);
            }
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue() && (event.getAnimation().get() instanceof DodgeAnimation || event.getAnimation().get() instanceof CancelableDodgeAnimation)) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19591_, 20, 2, true, false, false));
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_HURT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID);
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue()) {
            ((Player)container.getExecutor().getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 30, 0, true, false, false));
            if (container.getExecutor().getSkill(EpicFightSkills.HYPERVITALITY) == null) {
                container.getExecutor().playAnimationSynchronized(AnimsAgony.AGONY_SKY_DIVE, 0.0f);
            } else {
                container.getExecutor().playAnimationSynchronized(AnimsAgony.AGONY_SKY_DIVE_X, 0.0f);
            }
            if (container.getExecutor().getSkill(EpicFightSkills.HYPERVITALITY) == null) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.STACK.get(), (Object)(container.getStack() + 1));
            } else {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.STACK.get(), (Object)1);
            }
            if (!((Player)container.getExecutor().getOriginal()).m_7500_()) {
                EpicFightDamageSource damage = container.getExecutor().getDamageSource(AnimsAgony.AGONY_SKY_DIVE, InteractionHand.MAIN_HAND);
                damage.setStunType(StunType.NONE);
                ((Player)container.getExecutor().getOriginal()).m_6469_((DamageSource)damage, ((Player)container.getExecutor().getOriginal()).m_21223_() * 0.4f);
            }
            if (container.getExecutor().getSkill(EpicFightSkills.HYPERVITALITY) == null && !((Player)container.getExecutor().getOriginal()).m_7500_()) {
                this.setStackSynchronize(container, 0);
            }
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ACTIVE.get(), (Object)false);
            container.activate();
        } else {
            container.getExecutor().playAnimationSynchronized(AnimsAgony.AGONY_RISING_EAGLE, 0.0f);
            float distance = 20 + 10 * EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)container.getExecutor().getOriginal()));
            AABB box = AABB.m_165882_((Vec3)((Player)container.getExecutor().getOriginal()).m_20182_(), (double)(distance * 2.0f), (double)(distance * 2.0f), (double)(distance * 2.0f));
            List list = ((Player)container.getExecutor().getOriginal()).m_9236_().m_45933_(container.getExecutor().getOriginal(), box);
            for (Entity entity : list) {
                OwnableEntity animal;
                LivingEntity livingEntity;
                OwnableEntity pet;
                if (entity instanceof ArmorStand || entity instanceof OwnableEntity && (pet = (OwnableEntity)entity).m_269323_() == container.getExecutor().getOriginal() || !(entity.m_20270_(container.getExecutor().getOriginal()) < distance)) continue;
                double distance_to_target = Math.sqrt(Math.pow(((Player)container.getExecutor().getOriginal()).m_20182_().m_7096_() - entity.m_20185_(), 2.0) + Math.pow(((Player)container.getExecutor().getOriginal()).m_20182_().m_7094_() - entity.m_20189_(), 2.0) + Math.pow(((Player)container.getExecutor().getOriginal()).m_20182_().m_7098_() - entity.m_20186_(), 2.0));
                double power = Math.max(-(1.0 - distance_to_target / 50.0) * 3.0, -(distance_to_target / 50.0) * 12.0);
                if (entity instanceof ItemEntity || entity instanceof ExperienceOrb) {
                    power = -(distance_to_target / 50.0) * 18.0;
                }
                double d1 = ((Player)container.getExecutor().getOriginal()).m_20182_().m_7096_() - entity.m_20185_();
                double d2 = ((Player)container.getExecutor().getOriginal()).m_20182_().m_7098_() - 1.0 - entity.m_20186_();
                double d0 = ((Player)container.getExecutor().getOriginal()).m_20182_().m_7094_() - entity.m_20189_();
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                if (entity instanceof LivingEntity) {
                    power *= 1.0 - ((LivingEntity)entity).m_21133_(Attributes.f_22278_);
                }
                entity.f_19812_ = true;
                Vec3 vec3 = entity.m_20184_();
                Vec3 vec31 = new Vec3(d1, d2, d0).m_82541_().m_82490_(power);
                boolean noFalling = true;
                boolean notPet = true;
                if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_(MobEffects.f_19591_)) {
                    noFalling = false;
                }
                if (entity instanceof OwnableEntity && (animal = (OwnableEntity)entity).m_269323_() != container.getExecutor().getOriginal()) {
                    notPet = false;
                }
                if (!noFalling || !notPet) continue;
                entity.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, vec3.f_82480_ / 2.0 - vec31.f_82480_, vec3.f_82481_ / 2.0 - vec31.f_82481_);
            }
        }
    }

    public boolean resourcePredicate(PlayerPatch<?> executer, SkillCastEvent SCevent) {
        if (executer.getSkill(EpicFightSkills.HYPERVITALITY) != null && executer.getSkill(EpicFightSkills.HYPERVITALITY).isActivated()) {
            return true;
        }
        if (((Boolean)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue()) {
            return super.resourcePredicate(executer, SCevent);
        }
        return executer.consumeForSkill((Skill)this, Skill.Resource.STAMINA, 8.0f);
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        executer.updateEntityState();
        if (executer.getSkill(EpicFightSkills.HYPERVITALITY) != null) {
            return executer.getEntityState().canBasicAttack();
        }
        return executer.getEntityState().canUseSkill();
    }

    public boolean canExecute(SkillContainer container) {
        if (container.getExecutor().isLogicalClient()) {
            return super.canExecute(container);
        }
        ItemStack itemstack = ((Player)container.getExecutor().getOriginal()).m_21205_();
        if (!((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue()) {
            return EpicFightCapabilities.getItemStackCapability((ItemStack)itemstack).getInnateSkill(container.getExecutor(), itemstack) == this && ((Player)container.getExecutor().getOriginal()).m_20202_() == null && ((Player)container.getExecutor().getOriginal()).f_19789_ == 0.0f;
        }
        return EpicFightCapabilities.getItemStackCapability((ItemStack)itemstack).getInnateSkill(container.getExecutor(), itemstack) == this && ((Player)container.getExecutor().getOriginal()).m_20202_() == null;
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Plunge :");
        return list;
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient() && ((Player)container.getExecutor().getOriginal()).m_20096_() && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue()) {
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.ACTIVE.get(), (Object)false);
        }
    }
}

