/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponpassive;

import java.util.Random;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.DeathHarvestOrb;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class EvilTachiPassive
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("13118679-312b-4dfa-bdf8-cc58ea9c5b07");

    public EvilTachiPassive(SkillBuilder<? extends PassiveSkill> builder) {
        super(builder.setActivateType(Skill.ActivateType.DURATION_INFINITE));
    }

    public void onInitiate(SkillContainer container) {
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID, event -> {});
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {});
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID, event -> {});
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID, event -> {
            boolean isSpecialAtack;
            PlayerPatch playerpatch = container.getExecutor();
            Player original = (Player)playerpatch.getOriginal();
            int chance = Math.abs(new Random().nextInt()) % 100;
            int sweping = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)container.getExecutor().getOriginal()));
            boolean bl = isSpecialAtack = !((StaticAnimation)event.getDamageSource().getAnimation().get()).isBasicAttackAnimation();
            if (event.getTarget().m_6084_()) {
                int power;
                if (event.getTarget().m_21023_(MobEffects.f_19615_)) {
                    power = event.getTarget().m_21124_(MobEffects.f_19615_).m_19564_();
                    int duration = event.getTarget().m_21124_(MobEffects.f_19615_).m_19557_() - 20;
                    original.m_5634_(1.0f);
                    event.getTarget().m_21195_(MobEffects.f_19615_);
                    if (duration > 0) {
                        event.getTarget().m_7292_(new MobEffectInstance(MobEffects.f_19615_, duration, power, false, true));
                    }
                }
                float f = chance;
                float f2 = 20.0f + (float)sweping * 10.0f;
                float f3 = isSpecialAtack ? 2.0f : 1.0f;
                if (f < f2 * f3) {
                    if (event.getTarget().m_21023_(MobEffects.f_19615_)) {
                        power = event.getTarget().m_21124_(MobEffects.f_19615_).m_19564_();
                        event.getTarget().m_21195_(MobEffects.f_19615_);
                        event.getTarget().m_7292_(new MobEffectInstance(MobEffects.f_19615_, 120, ++power, false, true));
                        original.m_9236_().m_6263_(null, original.m_20185_(), original.m_20186_(), original.m_20189_(), SoundEvents.f_12554_, original.m_5720_(), 0.3f, 1.25f);
                        if (((ServerPlayerPatch)event.getPlayerPatch()).getSkill(EpicFightSkills.DEATH_HARVEST) != null && event.getTarget().m_21023_(MobEffects.f_19615_)) {
                            for (int i = 0; i < power / 2; ++i) {
                                DeathHarvestOrb harvestOrb = new DeathHarvestOrb(original, event.getTarget().m_20185_(), event.getTarget().m_20186_() + (double)event.getTarget().m_20206_() * 0.5, event.getTarget().m_20189_(), 2);
                                original.m_9236_().m_7967_((Entity)harvestOrb);
                            }
                        }
                    } else {
                        event.getTarget().m_7292_(new MobEffectInstance(MobEffects.f_19615_, 120, 0, false, true));
                    }
                }
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_HURT, EVENT_UUID, event -> {});
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {});
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID, event -> {});
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_HURT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
    }

    public void updateContainer(SkillContainer container) {
        PlayerPatch entitypatch = container.getExecutor();
        int numberOf = entitypatch.getEntityState().turningLocked() && !entitypatch.getEntityState().canBasicAttack() && !entitypatch.getEntityState().hurt() || entitypatch.getEntityState().attacking() ? 10 : 1;
        float partialScale = 1.0f / (float)(numberOf - 1);
        float interpolation = 0.0f;
        for (int i = 0; i < numberOf; ++i) {
            OpenMatrix4f transformMatrix = entitypatch.getArmature().getBoundTransformFor(entitypatch.getAnimator().getPose(interpolation), ((HumanoidArmature)Armatures.BIPED.get()).toolR);
            transformMatrix.translate(new Vec3f(-0.03f, -0.05f, -0.7f));
            OpenMatrix4f.mul((OpenMatrix4f)new OpenMatrix4f().rotate(-((float)Math.toRadians(entitypatch.getYRot() + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f)), (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
            transformMatrix.translate(new Vec3f(-0.03f, -0.05f, -(new Random().nextFloat() * 2.3f)));
            ((Player)entitypatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)transformMatrix.m30 + ((Player)entitypatch.getOriginal()).m_20185_() + (double)((new Random().nextFloat() - 0.5f) * 0.05f), (double)transformMatrix.m31 + ((Player)entitypatch.getOriginal()).m_20186_() + (double)((new Random().nextFloat() - 0.5f) * 0.05f), (double)transformMatrix.m32 + ((Player)entitypatch.getOriginal()).m_20189_() + (double)((new Random().nextFloat() - 0.5f) * 0.05f), 0.0, (double)(new Random().nextFloat() * -0.05f), 0.0);
            interpolation += partialScale;
        }
    }
}

