/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponpassive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.gameasset.animations.weapons.AnimsSatsujin;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class SatsujinPassive
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("010e5bfa-e6a2-11ec-8fea-0242ac120002");

    public SatsujinPassive(SkillBuilder<? extends PassiveSkill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            AnimationManager.AnimationAccessor[] resetAnimations;
            for (AnimationManager.AnimationAccessor staticAnimation : resetAnimations = new AnimationManager.AnimationAccessor[]{AnimsSatsujin.SATSUJIN_AUTO_1, AnimsSatsujin.SATSUJIN_AUTO_2, AnimsSatsujin.SATSUJIN_AUTO_3, AnimsSatsujin.SATSUJIN_HARUSAKI, AnimsSatsujin.SATSUJIN_SHEATHED_1, AnimsSatsujin.SATSUJIN_SHEATHED_2, AnimsSatsujin.SATSUJIN_SHEATHED_3, AnimsSatsujin.SATSUJIN_GUARD, AnimsSatsujin.SATSUJIN_GUARD_HIT, Animations.BIPED_HIT_SHORT, Animations.BIPED_HIT_LONG}) {
                if (!event.getAnimation().equals(staticAnimation)) continue;
                container.getSkill().setConsumptionSynchronize(container, 0.0f);
                container.getSkill().setStackSynchronize(container, 0);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> this.onReset(container));
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
    }

    public void onReset(SkillContainer container) {
        PlayerPatch executer = container.getExecutor();
        if (!executer.isLogicalClient() && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHEATH.get())).booleanValue()) {
            ServerPlayerPatch playerpatch = (ServerPlayerPatch)executer;
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SHEATH.get(), (Object)false);
            playerpatch.modifyLivingMotionByCurrentItem(false);
            container.getSkill().setConsumptionSynchronize(container, 0.0f);
        }
    }

    public void setConsumption(SkillContainer container, float value) {
        PlayerPatch executer = container.getExecutor();
        if (!executer.isLogicalClient() && this.consumption < value && !executer.getEntityState().inaction()) {
            ServerPlayer serverPlayer = (ServerPlayer)executer.getOriginal();
            if (!((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHEATH.get())).booleanValue()) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SHEATH.get(), (Object)true);
                boolean flag = false;
                if (container.getExecutor().getSkill(WOMSkills.MEDITATION) == null) {
                    flag = true;
                } else if ((Integer)container.getExecutor().getSkill(WOMSkills.MEDITATION).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) == 0) {
                    flag = true;
                }
                if (flag) {
                    ((ServerPlayerPatch)executer).modifyLivingMotionByCurrentItem(false);
                    executer.playAnimationInClientSide(AnimsSatsujin.SATSUJIN_SHEATHE, 0.0f);
                }
            } else {
                ((ServerPlayerPatch)executer).modifyLivingMotionByCurrentItem(false);
            }
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SHEATH.get(), (Object)true);
        }
        super.setConsumption(container, value);
    }

    public boolean shouldDeactivateAutomatically(PlayerPatch<?> executer) {
        return true;
    }

    public float getCooldownRegenPerSecond(PlayerPatch<?> player) {
        return ((Player)player.getOriginal()).m_6117_() ? 0.0f : 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        if (container.getExecutor().getSkill(WOMSkills.SAKURA_STATE) != null) {
            return (Integer)container.getExecutor().getSkill(WOMSkills.SAKURA_STATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get()) > 0;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)0.8f, (float)0.9f, (float)0.7f);
        guiGraphics.m_280411_(WOMSkills.SAKURA_STATE.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        String string = String.valueOf(container.getExecutor().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.STACK.get()));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.drawString(gui.getFont(), string, x + 18.0f - (float)(gui.getFont().m_92895_(string) / 2), y + 8.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }
}

