/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.world.capabilities.item;

import com.mojang.datafixers.util.Pair;
import java.util.function.Function;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.gameasset.animations.weapons.AnimsAgony;
import reascer.wom.gameasset.animations.weapons.AnimsEnderblaster;
import reascer.wom.gameasset.animations.weapons.AnimsHerrscher;
import reascer.wom.gameasset.animations.weapons.AnimsMoonless;
import reascer.wom.gameasset.animations.weapons.AnimsNapoleon;
import reascer.wom.gameasset.animations.weapons.AnimsOrbit;
import reascer.wom.gameasset.animations.weapons.AnimsRuine;
import reascer.wom.gameasset.animations.weapons.AnimsSatsujin;
import reascer.wom.gameasset.animations.weapons.AnimsSolar;
import reascer.wom.gameasset.colliders.WOMWeaponColliders;
import reascer.wom.main.WeaponsOfMinecraft;
import reascer.wom.particle.WOMParticles;
import reascer.wom.skill.WOMSkillDataKeys;
import reascer.wom.world.capabilities.item.GesetzCapability;
import reascer.wom.world.capabilities.item.WOMWeaponCategories;
import reascer.wom.world.item.WOMItems;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.forgeevent.WeaponCapabilityPresetRegistryEvent;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCapability;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

@Mod.EventBusSubscriber(modid="wom", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WOMWeaponCapabilityPresets {
    public static final Function<Item, CapabilityItem.Builder> STAFF = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)CapabilityItem.WeaponCategories.SPEAR).styleProvider(playerpatch -> CapabilityItem.Styles.TWO_HAND).collider(WOMWeaponColliders.STAFF).hitSound((SoundEvent)EpicFightSounds.BLUNT_HIT.get()).hitParticle((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).canBePlacedOffhand(false).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new AnimationManager.AnimationAccessor[]{WOMAnimations.STAFF_AUTO_1, WOMAnimations.STAFF_AUTO_2, WOMAnimations.STAFF_AUTO_3, WOMAnimations.STAFF_SQUALL, WOMAnimations.STAFF_KINKONG}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new AnimationManager.AnimationAccessor[]{Animations.SPEAR_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> WOMSkills.CHARYBDIS).comboCancel(style -> false).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, WOMAnimations.STAFF_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, WOMAnimations.STAFF_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, WOMAnimations.STAFF_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, WOMAnimations.STAFF_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_SPEAR).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, Animations.SPEAR_GUARD);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> AGONY = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)CapabilityItem.WeaponCategories.SPEAR).styleProvider(playerpatch -> CapabilityItem.Styles.TWO_HAND).collider(WOMWeaponColliders.AGONY).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).canBePlacedOffhand(false).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new AnimationManager.AnimationAccessor[]{AnimsAgony.AGONY_AUTO_1, AnimsAgony.AGONY_AUTO_2, AnimsAgony.AGONY_AUTO_3, AnimsAgony.AGONY_AUTO_4, AnimsAgony.AGONY_CLAWSTRIKE, AnimsAgony.AGONY_RIPPING_FANGS}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new AnimationManager.AnimationAccessor[]{Animations.SPEAR_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> WOMSkills.AGONY_PLUNGE).comboCancel(style -> false).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, AnimsAgony.AGONY_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, AnimsAgony.AGONY_WALK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, AnimsAgony.AGONY_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, AnimsAgony.AGONY_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_SPEAR).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, AnimsAgony.AGONY_GUARD);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> TORMENT = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)WOMWeaponCategories.TORMENT).styleProvider(entitypatch -> {
            if (entitypatch instanceof PlayerPatch && ((PlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getRemainDuration() > 0) {
                return CapabilityItem.Styles.OCHS;
            }
            return CapabilityItem.Styles.TWO_HAND;
        }).collider(WOMWeaponColliders.TORMENT).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).swingSound((SoundEvent)EpicFightSounds.WHOOSH_BIG.get()).canBePlacedOffhand(false).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new AnimationManager.AnimationAccessor[]{WOMAnimations.TORMENT_AUTO_1, WOMAnimations.TORMENT_AUTO_2, WOMAnimations.TORMENT_AUTO_3, WOMAnimations.TORMENT_AUTO_4, WOMAnimations.TORMENT_DASH, WOMAnimations.TORMENT_AIRSLAM}).newStyleCombo((Style)CapabilityItem.Styles.OCHS, new AnimationManager.AnimationAccessor[]{WOMAnimations.TORMENT_BERSERK_AUTO_1, WOMAnimations.TORMENT_BERSERK_AUTO_2, WOMAnimations.TORMENT_BERSERK_DASH, WOMAnimations.TORMENT_BERSERK_AIRSLAM}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new AnimationManager.AnimationAccessor[]{Animations.SWORD_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> WOMSkills.TRUE_BERSERK).innateSkill((Style)CapabilityItem.Styles.OCHS, itemstack -> WOMSkills.TRUE_BERSERK).passiveSkill(WOMSkills.TORMENT_PASSIVE).comboCancel(style -> false).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, WOMAnimations.TORMENT_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, WOMAnimations.TORMENT_WALK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, WOMAnimations.TORMENT_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, WOMAnimations.TORMENT_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_SPEAR).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, WOMAnimations.TORMENT_CHARGE).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.IDLE, WOMAnimations.TORMENT_BERSERK_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.WALK, WOMAnimations.TORMENT_BERSERK_WALK).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.CHASE, WOMAnimations.TORMENT_BERSERK_RUN).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.RUN, WOMAnimations.TORMENT_BERSERK_RUN).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_SPEAR);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> RUINE = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)CapabilityItem.WeaponCategories.LONGSWORD).styleProvider(entitypatch -> {
            if (entitypatch instanceof PlayerPatch && ((PlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.BUFFED.get()) != null && ((Boolean)((PlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.BUFFED.get())).booleanValue()) {
                return CapabilityItem.Styles.OCHS;
            }
            return CapabilityItem.Styles.TWO_HAND;
        }).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).collider(WOMWeaponColliders.RUINE).canBePlacedOffhand(false).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new AnimationManager.AnimationAccessor[]{AnimsRuine.RUINE_AUTO_1, AnimsRuine.RUINE_AUTO_2, AnimsRuine.RUINE_AUTO_3, AnimsRuine.RUINE_AUTO_4, AnimsRuine.RUINE_CHATIMENT, AnimsRuine.RUINE_COMET}).newStyleCombo((Style)CapabilityItem.Styles.OCHS, new AnimationManager.AnimationAccessor[]{AnimsRuine.RUINE_AUTO_1, AnimsRuine.RUINE_AUTO_2, AnimsRuine.RUINE_AUTO_3, AnimsRuine.RUINE_AUTO_4, AnimsRuine.RUINE_CHATIMENT, AnimsRuine.RUINE_COMET}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new AnimationManager.AnimationAccessor[]{Animations.SWORD_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> WOMSkills.ENDER_ARCANE).innateSkill((Style)CapabilityItem.Styles.OCHS, itemstack -> WOMSkills.ENDER_ARCANE).passiveSkill(WOMSkills.RUINE_PASSIVE).comboCancel(style -> false).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, AnimsRuine.RUINE_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, AnimsRuine.RUINE_WALK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, AnimsRuine.RUINE_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SNEAK, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.KNEEL, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.JUMP, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, AnimsRuine.RUINE_GUARD).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.IDLE, AnimsRuine.RUINE_BOOSTED_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.WALK, AnimsRuine.RUINE_BOOSTED_WALK).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.CHASE, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.RUN, AnimsRuine.RUINE_RUN).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.SNEAK, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.KNEEL, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.JUMP, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.BLOCK, AnimsRuine.RUINE_GUARD);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> SATSUJIN = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)CapabilityItem.WeaponCategories.UCHIGATANA).styleProvider(entitypatch -> {
            PlayerPatch playerpatch;
            if (entitypatch instanceof PlayerPatch && (playerpatch = (PlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().hasData((SkillDataKey)WOMSkillDataKeys.SHEATH.get()) && ((Boolean)playerpatch.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SHEATH.get())).booleanValue()) {
                return CapabilityItem.Styles.SHEATH;
            }
            return CapabilityItem.Styles.TWO_HAND;
        }).passiveSkill(WOMSkills.SATSUJIN_PASSIVE).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).collider(WOMWeaponColliders.SATSUJIN).canBePlacedOffhand(false).newStyleCombo((Style)CapabilityItem.Styles.SHEATH, new AnimationManager.AnimationAccessor[]{AnimsSatsujin.SATSUJIN_SHEATHED_1, AnimsSatsujin.SATSUJIN_SHEATHED_2, AnimsSatsujin.SATSUJIN_SHEATHED_3, AnimsSatsujin.SATSUJIN_SHEATHED_DASH, AnimsSatsujin.SATSUJIN_TSUKUYOMI}).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new AnimationManager.AnimationAccessor[]{AnimsSatsujin.SATSUJIN_AUTO_1, AnimsSatsujin.SATSUJIN_AUTO_2, AnimsSatsujin.SATSUJIN_AUTO_3, AnimsSatsujin.SATSUJIN_HARUSAKI, AnimsSatsujin.SATSUJIN_TSUKUYOMI}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new AnimationManager.AnimationAccessor[]{Animations.SWORD_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.SHEATH, itemstack -> WOMSkills.SAKURA_STATE).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> WOMSkills.SAKURA_STATE).comboCancel(style -> false).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, AnimsSatsujin.SATSUJIN_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.KNEEL, AnimsSatsujin.SATSUJIN_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, AnimsSatsujin.SATSUJIN_WALK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, AnimsSatsujin.SATSUJIN_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, AnimsSatsujin.SATSUJIN_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SNEAK, AnimsSatsujin.SATSUJIN_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, AnimsSatsujin.SATSUJIN_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.FLOAT, AnimsSatsujin.SATSUJIN_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.FALL, AnimsSatsujin.SATSUJIN_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.SHEATH, (LivingMotion)LivingMotions.IDLE, AnimsSatsujin.SATSUJIN_SHEATHED_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.SHEATH, (LivingMotion)LivingMotions.KNEEL, AnimsSatsujin.SATSUJIN_SHEATHED_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.SHEATH, (LivingMotion)LivingMotions.WALK, AnimsSatsujin.SATSUJIN_SHEATHED_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.SHEATH, (LivingMotion)LivingMotions.CHASE, AnimsSatsujin.SATSUJIN_SHEATHED_RUN).livingMotionModifier((Style)CapabilityItem.Styles.SHEATH, (LivingMotion)LivingMotions.RUN, AnimsSatsujin.SATSUJIN_SHEATHED_RUN).livingMotionModifier((Style)CapabilityItem.Styles.SHEATH, (LivingMotion)LivingMotions.SNEAK, AnimsSatsujin.SATSUJIN_SHEATHED_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.SHEATH, (LivingMotion)LivingMotions.SWIM, AnimsSatsujin.SATSUJIN_SHEATHED_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.SHEATH, (LivingMotion)LivingMotions.FLOAT, AnimsSatsujin.SATSUJIN_SHEATHED_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.SHEATH, (LivingMotion)LivingMotions.FALL, AnimsSatsujin.SATSUJIN_SHEATHED_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, AnimsSatsujin.SATSUJIN_GUARD);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> ENDER_BLASTER = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().zoomInType(CapabilityItem.ZoomInType.CUSTOM).category((WeaponCategory)WOMWeaponCategories.ENDERBLASTER).styleProvider(playerpatch -> playerpatch.getHoldingItemCapability(InteractionHand.OFF_HAND).getWeaponCategory() == WOMWeaponCategories.ENDERBLASTER ? CapabilityItem.Styles.TWO_HAND : CapabilityItem.Styles.ONE_HAND).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).collider(WOMWeaponColliders.PUNCH).newStyleCombo((Style)CapabilityItem.Styles.ONE_HAND, new AnimationManager.AnimationAccessor[]{AnimsEnderblaster.ENDERBLASTER_ONEHAND_AUTO_1, AnimsEnderblaster.ENDERBLASTER_ONEHAND_AUTO_2, AnimsEnderblaster.ENDERBLASTER_ONEHAND_AUTO_3, AnimsEnderblaster.ENDERBLASTER_ONEHAND_AUTO_4, AnimsEnderblaster.ENDERBLASTER_ONEHAND_DASH, AnimsEnderblaster.ENDERBLASTER_ONEHAND_JUMPKICK}).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new AnimationManager.AnimationAccessor[]{AnimsEnderblaster.ENDERBLASTER_TWOHAND_AUTO_1, AnimsEnderblaster.ENDERBLASTER_TWOHAND_AUTO_2, AnimsEnderblaster.ENDERBLASTER_TWOHAND_AUTO_3, AnimsEnderblaster.ENDERBLASTER_TWOHAND_AUTO_4, AnimsEnderblaster.ENDERBLASTER_ONEHAND_DASH, AnimsEnderblaster.ENDERBLASTER_TWOHAND_TISHNAW}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new AnimationManager.AnimationAccessor[]{Animations.SWORD_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.ONE_HAND, itemstack -> WOMSkills.ENDER_BLAST).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> WOMSkills.ENDER_FUSION).comboCancel(style -> false).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.IDLE, AnimsEnderblaster.ENDERBLASTER_ONEHAND_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.WALK, AnimsEnderblaster.ENDERBLASTER_ONEHAND_WALK).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.CHASE, AnimsEnderblaster.ENDERBLASTER_ONEHAND_RUN).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.RUN, AnimsEnderblaster.ENDERBLASTER_ONEHAND_RUN).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_SWIM).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.BLOCK, AnimsEnderblaster.ENDERBLASTER_ONEHAND_AIMING).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, AnimsEnderblaster.ENDERBLASTER_TWOHAND_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, AnimsEnderblaster.ENDERBLASTER_TWOHAND_WALK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, AnimsEnderblaster.ENDERBLASTER_ONEHAND_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, AnimsEnderblaster.ENDERBLASTER_ONEHAND_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_SWIM).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, AnimsEnderblaster.ENDERBLASTER_TWOHAND_AIMING).weaponCombinationPredicator(entitypatch -> EpicFightCapabilities.getItemStackCapability((ItemStack)((LivingEntity)entitypatch.getOriginal()).m_21206_()).getWeaponCollider() == WOMWeaponColliders.PUNCH);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> CLAWED_GAUNTLE = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)CapabilityItem.WeaponCategories.FIST).styleProvider(playerpatch -> playerpatch.getHoldingItemCapability(InteractionHand.OFF_HAND).getWeaponCategory() == CapabilityItem.WeaponCategories.FIST ? CapabilityItem.Styles.TWO_HAND : CapabilityItem.Styles.ONE_HAND).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).hitParticle((HitParticleType)EpicFightParticles.HIT_BLADE.get()).collider(WOMWeaponColliders.PUNCH).newStyleCombo((Style)CapabilityItem.Styles.ONE_HAND, new AnimationManager.AnimationAccessor[]{AnimsEnderblaster.ENDERBLASTER_ONEHAND_AUTO_2, AnimsEnderblaster.ENDERBLASTER_ONEHAND_AUTO_3, Animations.FIST_AUTO2, AnimsEnderblaster.ENDERBLASTER_ONEHAND_DASH, AnimsEnderblaster.ENDERBLASTER_TWOHAND_TISHNAW}).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new AnimationManager.AnimationAccessor[]{Animations.FIST_AUTO2, Animations.FIST_AUTO1, AnimsEnderblaster.ENDERBLASTER_TWOHAND_AUTO_2, AnimsEnderblaster.ENDERBLASTER_TWOHAND_AUTO_3, AnimsEnderblaster.ENDERBLASTER_ONEHAND_DASH, AnimsEnderblaster.ENDERBLASTER_TWOHAND_TISHNAW}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new AnimationManager.AnimationAccessor[]{Animations.SPEAR_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.ONE_HAND, itemstack -> EpicFightSkills.RELENTLESS_COMBO).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> EpicFightSkills.RELENTLESS_COMBO).comboCancel(style -> false).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.IDLE, AnimsEnderblaster.ENDERBLASTER_ONEHAND_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.WALK, AnimsEnderblaster.ENDERBLASTER_ONEHAND_WALK).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.CHASE, Animations.BIPED_RUN).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.RUN, Animations.BIPED_RUN).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_SWIM).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.BLOCK, Animations.BIPED_BLOCK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, AnimsEnderblaster.ENDERBLASTER_TWOHAND_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, AnimsEnderblaster.ENDERBLASTER_TWOHAND_WALK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, Animations.BIPED_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, Animations.BIPED_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_SWIM).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, Animations.BIPED_BLOCK).weaponCombinationPredicator(entitypatch -> EpicFightCapabilities.getItemStackCapability((ItemStack)((LivingEntity)entitypatch.getOriginal()).m_21206_()).getWeaponCollider() == WOMWeaponColliders.PUNCH);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> ANTITHEUS = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().zoomInType(CapabilityItem.ZoomInType.CUSTOM).category((WeaponCategory)WOMWeaponCategories.ANTITHEUS).styleProvider(entitypatch -> {
            if (entitypatch instanceof PlayerPatch && ((PlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getRemainDuration() > 0) {
                return CapabilityItem.Styles.OCHS;
            }
            return CapabilityItem.Styles.TWO_HAND;
        }).collider(WOMWeaponColliders.ANTITHEUS).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).swingSound((SoundEvent)EpicFightSounds.WHOOSH.get()).passiveSkill(WOMSkills.DEMON_MARK_PASSIVE).canBePlacedOffhand(false).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new AnimationManager.AnimationAccessor[]{WOMAnimations.ANTITHEUS_AUTO_1, WOMAnimations.ANTITHEUS_AUTO_2, WOMAnimations.ANTITHEUS_AUTO_3, WOMAnimations.ANTITHEUS_AUTO_4, WOMAnimations.ANTITHEUS_AGRESSION, WOMAnimations.ANTITHEUS_GUILLOTINE}).newStyleCombo((Style)CapabilityItem.Styles.OCHS, new AnimationManager.AnimationAccessor[]{WOMAnimations.ANTITHEUS_ASCENDED_AUTO_1, WOMAnimations.ANTITHEUS_ASCENDED_AUTO_2, WOMAnimations.ANTITHEUS_ASCENDED_AUTO_3, WOMAnimations.ANTITHEUS_ASCENDED_BLINK, WOMAnimations.ANTITHEUS_ASCENDED_DEATHFALL}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new AnimationManager.AnimationAccessor[]{Animations.SWORD_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> WOMSkills.DEMONIC_ASCENSION).innateSkill((Style)CapabilityItem.Styles.OCHS, itemstack -> WOMSkills.DEMONIC_ASCENSION).comboCancel(style -> false).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, WOMAnimations.ANTITHEUS_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, WOMAnimations.ANTITHEUS_WALK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, WOMAnimations.ANTITHEUS_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, WOMAnimations.ANTITHEUS_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_SPEAR).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, WOMAnimations.ANTITHEUS_AIMING).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.IDLE, WOMAnimations.ANTITHEUS_ASCENDED_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.WALK, WOMAnimations.ANTITHEUS_ASCENDED_WALK).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.CHASE, WOMAnimations.ANTITHEUS_ASCENDED_RUN).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.RUN, WOMAnimations.ANTITHEUS_ASCENDED_RUN).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_SWIM);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> HERRSCHER = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)CapabilityItem.WeaponCategories.SWORD).styleProvider(livingentitypatch -> {
            PlayerPatch playerpatch;
            if (livingentitypatch.getHoldingItemCapability(InteractionHand.OFF_HAND).getWeaponCategory() == CapabilityItem.WeaponCategories.SWORD && !((LivingEntity)livingentitypatch.getOriginal()).m_21120_(InteractionHand.OFF_HAND).m_150930_((Item)WOMItems.GESETZ.get())) {
                return CapabilityItem.Styles.TWO_HAND;
            }
            if (livingentitypatch instanceof PlayerPatch && (playerpatch = (PlayerPatch)livingentitypatch).getSkill(WOMSkills.REGIERUNG) != null && playerpatch.getSkill(WOMSkills.REGIERUNG).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) != null && ((Boolean)playerpatch.getSkill(WOMSkills.REGIERUNG).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.HOLDING_STANCE.get())).booleanValue()) {
                return CapabilityItem.Styles.COMMON;
            }
            return CapabilityItem.Styles.ONE_HAND;
        }).collider(WOMWeaponColliders.HERSCHER).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).comboCancel(style -> false).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new AnimationManager.AnimationAccessor[]{Animations.SWORD_DUAL_AUTO1, Animations.SWORD_DUAL_AUTO2, Animations.SWORD_DUAL_AUTO3, Animations.SWORD_DUAL_DASH, Animations.SWORD_DUAL_AIR_SLASH}).newStyleCombo((Style)CapabilityItem.Styles.ONE_HAND, new AnimationManager.AnimationAccessor[]{AnimsHerrscher.HERRSCHER_AUTO_1, AnimsHerrscher.HERRSCHER_AUTO_2, AnimsHerrscher.HERRSCHER_AUTO_3, AnimsHerrscher.HERRSCHER_VERDAMMNIS, AnimsHerrscher.HERRSCHER_AUSROTTUNG}).newStyleCombo((Style)CapabilityItem.Styles.COMMON, new AnimationManager.AnimationAccessor[]{AnimsHerrscher.HERRSCHER_AUTO_1, AnimsHerrscher.HERRSCHER_AUTO_2, AnimsHerrscher.HERRSCHER_AUTO_3, AnimsHerrscher.HERRSCHER_VERDAMMNIS, AnimsHerrscher.HERRSCHER_AUSROTTUNG}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new AnimationManager.AnimationAccessor[]{Animations.SWORD_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> EpicFightSkills.DANCING_EDGE).innateSkill((Style)CapabilityItem.Styles.ONE_HAND, itemstack -> WOMSkills.REGIERUNG).innateSkill((Style)CapabilityItem.Styles.COMMON, itemstack -> WOMSkills.REGIERUNG).passiveSkill(WOMSkills.HERRSCHER_PASSIVE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, Animations.SWORD_DUAL_GUARD).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.IDLE, AnimsHerrscher.HERRSCHER_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.WALK, AnimsHerrscher.HERRSCHER_WALK).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.RUN, AnimsHerrscher.HERRSCHER_RUN).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.BLOCK, AnimsHerrscher.HERRSCHER_GUARD).livingMotionModifier((Style)CapabilityItem.Styles.COMMON, (LivingMotion)LivingMotions.BLOCK, AnimsHerrscher.HERRSCHER_MAHER_HOLD).livingMotionModifier((Style)CapabilityItem.Styles.COMMON, (LivingMotion)LivingMotions.BLOCK_SHIELD, AnimsHerrscher.HERRSCHER_MAHER_HOLD).livingMotionModifier((Style)CapabilityItem.Styles.COMMON, (LivingMotion)LivingMotions.IDLE, AnimsHerrscher.HERRSCHER_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.COMMON, (LivingMotion)LivingMotions.WALK, AnimsHerrscher.HERRSCHER_WALK).livingMotionModifier((Style)CapabilityItem.Styles.COMMON, (LivingMotion)LivingMotions.RUN, AnimsHerrscher.HERRSCHER_RUN).weaponCombinationPredicator(entitypatch -> EpicFightCapabilities.getItemStackCapability((ItemStack)((LivingEntity)entitypatch.getOriginal()).m_21206_()).getWeaponCategory() == CapabilityItem.WeaponCategories.SWORD);
        if (item instanceof TieredItem) {
            int harvestLevel = ((TieredItem)item).m_43314_().m_6604_();
            builder.addStyleAttibutes((Style)CapabilityItem.Styles.COMMON, Pair.of((Object)((Attribute)EpicFightAttributes.IMPACT.get()), (Object)EpicFightAttributes.getImpactModifier((double)(0.5 + 0.2 * (double)harvestLevel))));
            builder.addStyleAttibutes((Style)CapabilityItem.Styles.COMMON, Pair.of((Object)((Attribute)EpicFightAttributes.MAX_STRIKES.get()), (Object)EpicFightAttributes.getMaxStrikesModifier((int)1)));
        }
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> GESETZ = item -> GesetzCapability.builder().constructor(GesetzCapability::new).category((WeaponCategory)CapabilityItem.WeaponCategories.SHIELD);
    public static final Function<Item, CapabilityItem.Builder> MOONLESS = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)CapabilityItem.WeaponCategories.TACHI).styleProvider(entitypatch -> {
            PlayerPatch playerpatch;
            if (entitypatch instanceof PlayerPatch && (playerpatch = (PlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().hasData((SkillDataKey)WOMSkillDataKeys.VERSO.get()) && ((Boolean)playerpatch.getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.VERSO.get())).booleanValue()) {
                return CapabilityItem.Styles.OCHS;
            }
            return CapabilityItem.Styles.TWO_HAND;
        }).collider(WOMWeaponColliders.MOONLESS).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).comboCancel(style -> false).canBePlacedOffhand(false).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new AnimationManager.AnimationAccessor[]{AnimsMoonless.MOONLESS_AUTO_1, AnimsMoonless.MOONLESS_AUTO_2, AnimsMoonless.MOONLESS_AUTO_3, AnimsMoonless.MOONLESS_REVERSED_BYPASS, AnimsMoonless.MOONLESS_CRESCENT}).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> WOMSkills.lUNAR_ECLIPSE).newStyleCombo((Style)CapabilityItem.Styles.OCHS, new AnimationManager.AnimationAccessor[]{AnimsMoonless.MOONLESS_AUTO_1_VERSO, AnimsMoonless.MOONLESS_AUTO_2_VERSO, AnimsMoonless.MOONLESS_AUTO_3_VERSO, AnimsMoonless.MOONLESS_BYPASS, AnimsMoonless.MOONLESS_FULLMOON}).innateSkill((Style)CapabilityItem.Styles.OCHS, itemstack -> WOMSkills.lUNAR_ECLIPSE).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new AnimationManager.AnimationAccessor[]{Animations.SWORD_MOUNT_ATTACK}).passiveSkill(WOMSkills.LUNAR_ECHO_PASSIVE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, AnimsMoonless.MOONLESS_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, AnimsMoonless.MOONLESS_WALK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, AnimsMoonless.MOONLESS_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, AnimsMoonless.MOONLESS_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_SPEAR).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, AnimsMoonless.MOONLESS_GUARD).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.IDLE, AnimsMoonless.MOONLESS_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.WALK, AnimsMoonless.MOONLESS_WALK).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.CHASE, AnimsMoonless.MOONLESS_RUN).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.RUN, AnimsMoonless.MOONLESS_RUN).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_SPEAR).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.BLOCK, AnimsMoonless.MOONLESS_GUARD);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> SOLAR = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)CapabilityItem.WeaponCategories.GREATSWORD).styleProvider(entitypatch -> {
            PlayerPatch playerpatch;
            if (entitypatch instanceof PlayerPatch && (playerpatch = (PlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().hasData((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD.get()) && ((Boolean)playerpatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SOLAR_OBSCURIDAD.get())).booleanValue()) {
                return CapabilityItem.Styles.OCHS;
            }
            return CapabilityItem.Styles.TWO_HAND;
        }).collider(WOMWeaponColliders.SOLAR).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).swingSound((SoundEvent)EpicFightSounds.WHOOSH_BIG.get()).canBePlacedOffhand(false).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new AnimationManager.AnimationAccessor[]{AnimsSolar.SOLAR_AUTO_1, AnimsSolar.SOLAR_AUTO_2, AnimsSolar.SOLAR_AUTO_3, AnimsSolar.SOLAR_AUTO_4, AnimsSolar.SOLAR_QUEMADURA, AnimsSolar.SOLAR_HORNO}).newStyleCombo((Style)CapabilityItem.Styles.OCHS, new AnimationManager.AnimationAccessor[]{AnimsSolar.SOLAR_OBSCURIDAD_AUTO_1, AnimsSolar.SOLAR_OBSCURIDAD_AUTO_2, AnimsSolar.SOLAR_OBSCURIDAD_AUTO_3, AnimsSolar.SOLAR_OBSCURIDAD_AUTO_4, AnimsSolar.SOLAR_OBSCURIDAD_IMPACTO, AnimsSolar.SOLAR_OBSCURIDAD_DINAMITA}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new AnimationManager.AnimationAccessor[]{Animations.SWORD_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> WOMSkills.SOLAR_ARCANO).innateSkill((Style)CapabilityItem.Styles.OCHS, itemstack -> WOMSkills.SOLAR_ARCANO).passiveSkill(WOMSkills.SOLAR_PASSIVE).comboCancel(style -> false).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, AnimsSolar.SOLAR_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, AnimsSolar.SOLAR_WALK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, AnimsSolar.SOLAR_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, AnimsSolar.SOLAR_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, AnimsSolar.SOLAR_GUARD).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.IDLE, AnimsSolar.SOLAR_OBSCURIDAD_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.WALK, AnimsSolar.SOLAR_OBSCURIDAD_WALK).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.CHASE, AnimsSolar.SOLAR_OBSCURIDAD_RUN).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.RUN, AnimsSolar.SOLAR_OBSCURIDAD_RUN).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.OCHS, (LivingMotion)LivingMotions.BLOCK, AnimsSolar.SOLAR_GUARD);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> NAPOLEON = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)WOMWeaponCategories.NAPOLEON).styleProvider(playerpatch -> CapabilityItem.Styles.TWO_HAND).collider(WOMWeaponColliders.NAPOLEON).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).hitParticle((HitParticleType)WOMParticles.SOLAR_OBSCURIDAD_HIT.get()).canBePlacedOffhand(false).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new AnimationManager.AnimationAccessor[]{AnimsNapoleon.NAPOLEON_AUTO_1, AnimsNapoleon.NAPOLEON_AUTO_2, AnimsNapoleon.NAPOLEON_AUTO_3, AnimsNapoleon.NAPOLEON_AUTO_4, AnimsNapoleon.NAPOLEON_AUSTERLITZ, AnimsNapoleon.NAPOLEON_WATERLOW}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new AnimationManager.AnimationAccessor[]{Animations.SPEAR_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> WOMSkills.RECHARGEMENT).passiveSkill(WOMSkills.NAPOLEON_PASSIVE).comboCancel(style -> false).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, AnimsNapoleon.NAPOLEON_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, AnimsNapoleon.NAPOLEON_WALK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, AnimsNapoleon.NAPOLEON_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, AnimsNapoleon.NAPOLEON_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_SPEAR);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> EVIL_TACHI = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)CapabilityItem.WeaponCategories.TACHI).styleProvider(playerpatch -> CapabilityItem.Styles.TWO_HAND).collider(WOMWeaponColliders.EVIL_TACHI).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).hitParticle((HitParticleType)WOMParticles.SHARPCUT_SLASH.get()).canBePlacedOffhand(false).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new AnimationManager.AnimationAccessor[]{Animations.TACHI_AUTO1, Animations.TACHI_AUTO2, Animations.TACHI_AUTO3, Animations.TACHI_DASH, Animations.SPEAR_TWOHAND_AIR_SLASH}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new AnimationManager.AnimationAccessor[]{Animations.SWORD_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> EpicFightSkills.RUSHING_TEMPO).passiveSkill(WOMSkills.EVIL_TACHI_PASSIVE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, Animations.BIPED_HOLD_TACHI).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.KNEEL, Animations.BIPED_HOLD_TACHI).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, Animations.BIPED_HOLD_TACHI).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, Animations.BIPED_HOLD_TACHI).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, Animations.BIPED_HOLD_TACHI).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SNEAK, Animations.BIPED_HOLD_TACHI).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_TACHI).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.FLOAT, Animations.BIPED_HOLD_TACHI).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.FALL, Animations.BIPED_HOLD_TACHI).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, Animations.LONGSWORD_GUARD);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> ORBIT = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)CapabilityItem.WeaponCategories.SPEAR).styleProvider(playerpatch -> CapabilityItem.Styles.TWO_HAND).collider(WOMWeaponColliders.ORBIT).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).hitParticle((HitParticleType)EpicFightParticles.HIT_BLADE.get()).canBePlacedOffhand(false).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new AnimationManager.AnimationAccessor[]{AnimsOrbit.ORBIT_ATTACK_1, AnimsOrbit.ORBIT_ATTACK_2, AnimsOrbit.ORBIT_ATTACK_3, AnimsOrbit.ORBIT_ATTACK_4, AnimsOrbit.ORBIT_SATELITE, AnimsOrbit.ORBIT_MAD_REACH}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new AnimationManager.AnimationAccessor[]{Animations.SPEAR_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> WOMSkills.ORBITAL_BEAM).comboCancel(style -> false).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, AnimsOrbit.ORBIT_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, AnimsOrbit.ORBIT_WALK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, AnimsOrbit.ORBIT_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, AnimsOrbit.ORBIT_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_SPEAR).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, Animations.SPEAR_GUARD);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> NOVA = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)CapabilityItem.WeaponCategories.TACHI).styleProvider(playerpatch -> playerpatch.getHoldingItemCapability(InteractionHand.OFF_HAND).getWeaponCategory() == CapabilityItem.WeaponCategories.TACHI ? CapabilityItem.Styles.TWO_HAND : CapabilityItem.Styles.ONE_HAND).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).collider(WOMWeaponColliders.RUINE).canBePlacedOffhand(true).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new AnimationManager.AnimationAccessor[]{Animations.SWORD_DUAL_AUTO1, Animations.SWORD_DUAL_AUTO2, Animations.SWORD_DUAL_AUTO3, Animations.SWORD_DUAL_DASH, Animations.SWORD_DUAL_AIR_SLASH}).newStyleCombo((Style)CapabilityItem.Styles.ONE_HAND, new AnimationManager.AnimationAccessor[]{AnimsRuine.RUINE_AUTO_1, AnimsRuine.RUINE_AUTO_2, AnimsRuine.RUINE_AUTO_3, AnimsRuine.RUINE_CHATIMENT, AnimsSatsujin.SATSUJIN_TSUKUYOMI}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new AnimationManager.AnimationAccessor[]{Animations.SWORD_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> EpicFightSkills.DANCING_EDGE).innateSkill((Style)CapabilityItem.Styles.ONE_HAND, itemstack -> EpicFightSkills.GRASPING_SPIRE).comboCancel(style -> false).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.IDLE, AnimsRuine.RUINE_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.WALK, AnimsRuine.RUINE_WALK).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.CHASE, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.RUN, AnimsRuine.RUINE_RUN).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.SNEAK, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.KNEEL, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.JUMP, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_GREATSWORD).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.BLOCK, AnimsRuine.RUINE_GUARD).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, Animations.SWORD_DUAL_GUARD).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, Animations.BIPED_HOLD_DUAL_WEAPON).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.KNEEL, Animations.BIPED_HOLD_DUAL_WEAPON).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, Animations.BIPED_HOLD_DUAL_WEAPON).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, Animations.BIPED_HOLD_DUAL_WEAPON).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, Animations.BIPED_RUN_DUAL).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SNEAK, Animations.BIPED_HOLD_DUAL_WEAPON).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_DUAL_WEAPON).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.FLOAT, Animations.BIPED_HOLD_DUAL_WEAPON).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.FALL, Animations.BIPED_HOLD_DUAL_WEAPON).weaponCombinationPredicator(entitypatch -> EpicFightCapabilities.getItemStackCapability((ItemStack)((LivingEntity)entitypatch.getOriginal()).m_21206_()).getWeaponCategory() == CapabilityItem.WeaponCategories.TACHI);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> BLACKSTAR = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)CapabilityItem.WeaponCategories.SPEAR).styleProvider(playerpatch -> CapabilityItem.Styles.TWO_HAND).collider(WOMWeaponColliders.STAFF_EXTENTION).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).hitParticle((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).canBePlacedOffhand(false).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new AnimationManager.AnimationAccessor[]{AnimsNapoleon.NAPOLEON_AUTO_1, WOMAnimations.TORMENT_CHARGED_ATTACK_1, AnimsNapoleon.NAPOLEON_AUSTERLITZ, AnimsNapoleon.NAPOLEON_AUTO_3, AnimsSolar.SOLAR_QUEMADURA, AnimsSolar.SOLAR_HORNO}).newStyleCombo((Style)CapabilityItem.Styles.MOUNT, new AnimationManager.AnimationAccessor[]{Animations.SPEAR_MOUNT_ATTACK}).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemstack -> EpicFightSkills.STEEL_WHIRLWIND).comboCancel(style -> false).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, WOMAnimations.STAFF_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, AnimsSolar.SOLAR_WALK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.CHASE, WOMAnimations.STAFF_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, AnimsSolar.SOLAR_RUN).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_HOLD_SPEAR).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, Animations.SPEAR_GUARD);
        return builder;
    };

    @SubscribeEvent
    public static void register(WeaponCapabilityPresetRegistryEvent event) {
        event.getTypeEntry().put(WeaponsOfMinecraft.identifier("staff"), STAFF);
        event.getTypeEntry().put(WeaponsOfMinecraft.identifier("agony"), AGONY);
        event.getTypeEntry().put(WeaponsOfMinecraft.identifier("torment"), TORMENT);
        event.getTypeEntry().put(WeaponsOfMinecraft.identifier("ruine"), RUINE);
        event.getTypeEntry().put(WeaponsOfMinecraft.identifier("satsujin"), SATSUJIN);
        event.getTypeEntry().put(WeaponsOfMinecraft.identifier("ender_blaster"), ENDER_BLASTER);
        event.getTypeEntry().put(WeaponsOfMinecraft.identifier("antitheus"), ANTITHEUS);
        event.getTypeEntry().put(WeaponsOfMinecraft.identifier("herrscher"), HERRSCHER);
        event.getTypeEntry().put(WeaponsOfMinecraft.identifier("gesetz"), GESETZ);
        event.getTypeEntry().put(WeaponsOfMinecraft.identifier("moonless"), MOONLESS);
        event.getTypeEntry().put(WeaponsOfMinecraft.identifier("solar"), SOLAR);
        event.getTypeEntry().put(WeaponsOfMinecraft.identifier("napoleon"), NAPOLEON);
        event.getTypeEntry().put(WeaponsOfMinecraft.identifier("evil_tachi"), EVIL_TACHI);
        event.getTypeEntry().put(WeaponsOfMinecraft.identifier("orbit"), ORBIT);
        event.getTypeEntry().put(WeaponsOfMinecraft.identifier("nova"), NOVA);
        event.getTypeEntry().put(WeaponsOfMinecraft.identifier("blackstar"), BLACKSTAR);
        event.getTypeEntry().put(WeaponsOfMinecraft.identifier("clawed_gauntle"), CLAWED_GAUNTLE);
    }
}

