/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.world.entity.mob;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import reascer.wom.gameasset.animations.weapons.AnimsRuine;
import reascer.wom.particle.WOMParticles;
import reascer.wom.world.damagesources.WOMExtraDamageInstance;
import reascer.wom.world.entity.WOMEntities;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class EnderHand
extends FlyingMob
implements OwnableEntity {
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(TamableAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public EnderHand(EntityType<? extends FlyingMob> entityType, Level level) {
        super(entityType, level);
        this.m_20242_(true);
        this.f_19794_ = true;
    }

    public EnderHand(ServerLevel level, Vec3 position, LivingEntity owner, LivingEntity target) {
        this((EntityType<? extends FlyingMob>)((EntityType)WOMEntities.ENDER_HAND.get()), (Level)level);
        this.m_146884_(position);
        this.m_7618_(EntityAnchorArgument.Anchor.FEET, owner.m_20182_());
        this.m_6710_(target);
        this.setOwnerUUID(owner.m_20148_());
    }

    public boolean m_6469_(DamageSource damagesource, float damage) {
        if (!damagesource.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        return super.m_6469_(damagesource, damage);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22266_((Attribute)EpicFightAttributes.WEIGHT.get()).m_22266_((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).m_22266_((Attribute)EpicFightAttributes.IMPACT.get()).m_22266_((Attribute)EpicFightAttributes.MAX_STRIKES.get()).m_22266_(Attributes.f_22281_);
    }

    public void m_8024_() {
        ServerPlayerPatch serverPlayerPach;
        if (this.f_19797_ >= 60) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (this.f_19797_ == 20 && this.m_269323_() != null && this.m_5448_() != null && this.m_5448_().m_6084_() && (serverPlayerPach = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)this.m_269323_(), ServerPlayerPatch.class)) != null) {
            ServerPlayer player = (ServerPlayer)serverPlayerPach.getOriginal();
            ServerLevel serverLevel = (ServerLevel)player.m_9236_();
            LivingEntity entity = this.m_5448_();
            EpicFightDamageSource damagesource = new EpicFightDamageSource((DamageSource)serverPlayerPach.getDamageSource(AnimsRuine.RUINE_PLUNDER, InteractionHand.MAIN_HAND));
            damagesource.setBaseImpact(4.0f);
            damagesource.setStunType(StunType.HOLD);
            damagesource.attachDamageModifier(ValueModifier.multiplier((float)2.6f));
            damagesource.addRuntimeTag(EpicFightDamageTypeTags.WEAPON_INNATE);
            damagesource.addExtraDamage(WOMExtraDamageInstance.WOM_SWEEPING_EDGE_ENCHANTMENT.create(new float[]{0.8f}));
            entity.m_6469_((DamageSource)damagesource, (float)player.m_21133_(Attributes.f_22281_));
            if (entity.m_21023_(MobEffects.f_19597_)) {
                entity.m_21195_(MobEffects.f_19597_);
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, (12 + 4 * EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)player)) * 20, 0, false, true));
            } else {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, (9 + 3 * EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)player)) * 20, 0, false, true));
            }
            if (entity.m_21023_(MobEffects.f_19599_)) {
                entity.m_21195_(MobEffects.f_19599_);
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, (12 + 4 * EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)player)) * 20, 0, false, true));
            } else {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, (9 + 3 * EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)player)) * 20, 0, false, true));
            }
            serverPlayerPach.setStamina(serverPlayerPach.getStamina() + serverPlayerPach.getMaxStamina() * 0.05f);
            ((ServerPlayer)serverPlayerPach.getOriginal()).m_5634_((float)(1 + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)player)));
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)WOMParticles.ENDERBLASTER_BULLET.get()), entity.m_20185_(), entity.m_20186_() + (double)1.2f, entity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            serverLevel.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11897_, player.m_5720_(), 1.0f, 0.5f);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
    }

    public void m_7380_(CompoundTag p_21819_) {
        super.m_7380_(p_21819_);
        if (this.m_21805_() != null) {
            p_21819_.m_128362_("Owner", this.m_21805_());
        }
    }

    public void m_7378_(CompoundTag p_21815_) {
        UUID uuid;
        super.m_7378_(p_21815_);
        if (p_21815_.m_128403_("Owner")) {
            uuid = p_21815_.m_128342_("Owner");
        } else {
            String s = p_21815_.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID p_21817_) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(p_21817_));
    }
}

