/*
 * Decompiled with CFR 0.152.
 */
package simple.spawn;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import simple.spawn.Main;

public class SpawnCommand
implements CommandExecutor {
    private final Main plugin;

    public SpawnCommand(Main plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        FileConfiguration config = this.plugin.getConfig();
        String worldName = config.getString("spawn.world");
        double x = config.getDouble("spawn.x");
        double y = config.getDouble("spawn.y");
        double z = config.getDouble("spawn.z");
        float yaw = (float)config.getDouble("spawn.yaw");
        float pitch = (float)config.getDouble("spawn.pitch");
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            player.sendMessage("The specified world in the config does not exist.");
            return true;
        }
        Location loc = new Location(world, x, y, z, yaw, pitch);
        player.teleport(loc);
        return true;
    }
}

