/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryType;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.util.Util;
import doggytalents.common.variant.DogVariant;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;

public class DoggyRegistries {
    public static Supplier<Registry<DogVariant>> DOG_VARIANT;

    public static void newRegistry(NewRegistryEvent event) {
        DoggyTalentsAPI.TALENTS = DoggyRegistries.makeRegistry(event, Keys.TALENTS_REGISTRY, Talent.class);
        DoggyTalentsAPI.ACCESSORIES = DoggyRegistries.makeRegistry(event, Keys.ACCESSORIES_REGISTRY, Accessory.class);
        DoggyTalentsAPI.ACCESSORY_TYPE = DoggyRegistries.makeRegistry(event, Keys.ACCESSORY_TYPE_REGISTRY, AccessoryType.class, true);
        DoggyTalentsAPI.TALENT_OPTIONS = DoggyRegistries.makeDogSyncRegistry(event);
        DOG_VARIANT = DoggyRegistries.makeRegistry(event, Keys.DOG_VARIANT, DogVariant.class, Util.getResource("missing"));
    }

    private static <T> Supplier<Registry<T>> makeRegistry(NewRegistryEvent event, ResourceKey<Registry<T>> key, Class<T> type, boolean disableSync) {
        RegistryBuilder builder = new RegistryBuilder(key);
        builder.sync(!disableSync);
        Registry ret = event.create(builder);
        return () -> ret;
    }

    private static <T> Supplier<Registry<T>> makeRegistry(NewRegistryEvent event, ResourceKey<Registry<T>> key, Class<T> type) {
        return DoggyRegistries.makeRegistry(event, key, type, false);
    }

    private static Supplier<Registry<TalentOption<?>>> makeDogSyncRegistry(NewRegistryEvent event) {
        RegistryBuilder builder = new RegistryBuilder(Keys.TALENT_OPTION);
        builder.sync(true);
        Registry ret = event.create(builder);
        return () -> ret;
    }

    private static <T> ResourceKey<Registry<T>> regKey(String key) {
        ResourceLocation rl = Util.getResource(key);
        return ResourceKey.createRegistryKey((ResourceLocation)rl);
    }

    private static <T> Supplier<Registry<T>> makeRegistry(NewRegistryEvent event, ResourceKey<Registry<T>> key, Class<T> type, ResourceLocation defaultKey) {
        RegistryBuilder builder = new RegistryBuilder(key);
        builder.sync(true);
        builder.defaultKey(defaultKey);
        Registry ret = event.create(builder);
        return () -> ret;
    }

    public class Keys {
        public static final ResourceKey<Registry<Talent>> TALENTS_REGISTRY = DoggyRegistries.regKey("talents");
        public static final ResourceKey<Registry<Accessory>> ACCESSORIES_REGISTRY = DoggyRegistries.regKey("accessories");
        public static final ResourceKey<Registry<AccessoryType>> ACCESSORY_TYPE_REGISTRY = DoggyRegistries.regKey("accessory_type");
        public static final ResourceKey<Registry<DogVariant>> DOG_VARIANT = DoggyRegistries.regKey("dog_variant");
        public static final ResourceKey<Registry<TalentOption<?>>> TALENT_OPTION = DoggyRegistries.regKey("talent_options");

        public Keys(DoggyRegistries this$0) {
        }
    }
}

