/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import doggytalents.client.ClientSetup;
import doggytalents.client.backward_imitate.LegacyBlockEntityRendererUtil_1_21_9;
import doggytalents.client.block.model.RiceMillModel;
import doggytalents.common.block.RiceMillBlock;
import doggytalents.common.block.tileentity.RiceMillBlockEntity;
import doggytalents.common.lib.Resources;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionfc;

public class RiceMillRenderer
extends LegacyBlockEntityRendererUtil_1_21_9.BlockEntityRenderer_1_21_9<RiceMillBlockEntity> {
    private RiceMillModel model;

    public RiceMillRenderer(BlockEntityRendererProvider.Context ctx) {
        this.model = new RiceMillModel(ctx.bakeLayer(ClientSetup.RICE_MILL));
    }

    @Override
    public void submit(RiceMillBlockEntity mill, float pTicks, PoseStack stack, LegacyBlockEntityRendererUtil_1_21_9.RenderContext_1_21_9<RiceMillBlockEntity> context_1_21_9, int light, int overlay) {
        stack.pushPose();
        stack.scale(1.0f, -1.0f, -1.0f);
        stack.translate(0.5f, 0.0f, -0.5f);
        BlockState state = mill.getBlockState();
        Direction facing = RiceMillBlock.getFacing(state);
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(facing.getOpposite().toYRot()));
        stack.scale(2.0f, 2.0f, 2.0f);
        stack.translate(-0.25f, -1.501f, -0.25f);
        context_1_21_9.renderState().defferedSetup_1_21_9 = () -> this.model.setUpMillAnim(mill, pTicks);
        RenderType renderType_1_21_9 = RenderType.entityCutoutNoCull((ResourceLocation)Resources.RICE_MILL_MODEL);
        this.submitModel(context_1_21_9, this.model, renderType_1_21_9, stack, light, OverlayTexture.NO_OVERLAY, -1);
        stack.popPose();
    }

    public AABB getRenderBoundingBox(RiceMillBlockEntity mill) {
        return mill.getRenderBoundingBox();
    }
}

