/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import doggytalents.client.backward_imitate.BaseDogModel_21_3;
import doggytalents.client.backward_imitate.ModelUtil_1_21_9;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.common.entity.Dog;
import java.util.Optional;
import net.minecraft.client.model.geom.ModelPart;
import org.joml.Vector3f;

public abstract class SyncedAccessoryModel
extends BaseDogModel_21_3 {
    public final ModelPart root;
    private Vector3f pivot = DogModel.DEFAULT_ROOT_PIVOT;
    public Optional<ModelPart> head = Optional.empty();
    public Optional<ModelPart> realHead = Optional.empty();
    public Optional<ModelPart> body = Optional.empty();
    public Optional<ModelPart> mane = Optional.empty();
    public Optional<ModelPart> legBackRight = Optional.empty();
    public Optional<ModelPart> legBackLeft = Optional.empty();
    public Optional<ModelPart> legFrontRight = Optional.empty();
    public Optional<ModelPart> legFrontLeft = Optional.empty();
    public Optional<ModelPart> tail = Optional.empty();
    public Optional<ModelPart> realTail = Optional.empty();

    public SyncedAccessoryModel(ModelPart root) {
        this.root = root;
        this.populatePart(root);
    }

    protected abstract void populatePart(ModelPart var1);

    public void sync(DogModel dogModel) {
        this.syncPart(this.root, dogModel.root);
        this.syncPart(this.head, dogModel.head);
        this.syncPart(this.realHead, dogModel.realHead);
        this.syncPart(this.body, dogModel.body);
        this.syncPart(this.mane, dogModel.mane);
        this.syncPart(this.legBackRight, dogModel.legBackRight);
        this.syncPart(this.legBackLeft, dogModel.legBackLeft);
        this.syncPart(this.legFrontRight, dogModel.legFrontRight);
        this.syncPart(this.legFrontLeft, dogModel.legFrontLeft);
        this.syncPart(this.tail, dogModel.tail);
        this.syncPart(this.realTail, dogModel.realTail);
        this.pivot = DogModel.DEFAULT_ROOT_PIVOT;
        Vector3f custom_pivot = dogModel.getCustomRootPivotPoint();
        if (custom_pivot != null) {
            this.pivot = custom_pivot;
        }
    }

    private void syncPart(Optional<ModelPart> part, ModelPart dogPart) {
        part.ifPresent(p -> this.syncPart((ModelPart)p, dogPart));
    }

    private void syncPart(ModelPart part, ModelPart dogPart) {
        ModelUtil_1_21_9.copyModelPartFrom(part, dogPart);
    }

    @Override
    public void renderToBuffer(PoseStack stack, VertexConsumer p_103014_, int p_103015_, int p_103016_, int color_overlay) {
        DogModel.renderDogModelFromRootWithPivot(stack, this.createDogRenderContext(p_103014_, p_103015_, p_103016_, color_overlay));
    }

    public DogModel.DogModelRenderContext createDogRenderContext(VertexConsumer p_103014_, int p_103015_, int p_103016_, int color_overlay) {
        DogModel.DogRenderPartContext part_ctx = new DogModel.DogRenderPartContext(p_103014_, p_103015_, p_103016_, color_overlay);
        return new DogModel.DogModelRenderContext(this.root, this.pivot, SyncedAccessoryModel.getDogModelBabyHead(this.head, this.young), Optional.of(part_ctx), Optional.empty());
    }

    protected static Optional<ModelPart> getDogModelBabyHead(Optional<ModelPart> head, boolean young) {
        return young ? head : Optional.empty();
    }

    @Override
    public void prepareMobModel(Dog dogIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
    }

    @Override
    public void setupAnim(Dog entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }
}

