/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.DoggyItems;
import doggytalents.DoggyTalentsNext;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.client.DoggyKeybinds;
import doggytalents.client.backward_imitate.DogBedModifyingBakingResult_1_21_5;
import doggytalents.client.entity.model.animation.DogAnimationRegistry;
import doggytalents.client.entity.model.animation.DogKeyframeAnimations;
import doggytalents.client.entity.render.world.CanineTrackerLocateRenderer;
import doggytalents.client.screen.DogNewInfoScreen.DogNewInfoScreen;
import doggytalents.client.screen.DogNewInfoScreen.store.UIActionTypes;
import doggytalents.client.screen.DogNewInfoScreen.store.slice.TalentChangeHandlerSlice;
import doggytalents.client.screen.framework.Store;
import doggytalents.client.screen.framework.UIAction;
import doggytalents.client.screen.widget.DogInventoryButton;
import doggytalents.client.screen.widget.DoggySpin.DoggySpin;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogAnimationState;
import doggytalents.common.item.WhistleItem;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogMountData;
import doggytalents.common.network.packet.data.DogSyncData;
import doggytalents.common.network.packet.data.WhistleUseData;
import doggytalents.common.util.InventoryUtil;
import doggytalents.common.util.ItemUtil;
import doggytalents.common.util.PlayerUtil;
import doggytalents.common.util.Util;
import doggytalents.common.variant.DogVariant;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;

public class ClientEventHandler {
    public static void modifyBakedModels(ModelEvent.ModifyBakingResult event) {
        try {
            DogBedModifyingBakingResult_1_21_5.modifyBakedModels(event);
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.warn("Error modifying baking result. Reverting to default textures...");
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onInputEvent(MovementInputUpdateEvent event) {
        if (!event.getInput().keyPresses.jump()) {
            return;
        }
        Player entity = event.getEntity();
        Entity vehicle = entity.getVehicle();
        if (!entity.isPassenger()) {
            return;
        }
        if (!(vehicle instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)vehicle;
        if (!dog.canJump()) {
            return;
        }
        dog.setJumpPower(100);
    }

    @SubscribeEvent
    public void onScreenInit(ScreenEvent.Init.Post event) {
        DogInventoryButton.onScreenInit(event);
        DoggySpin.onScreenInit(event);
    }

    @SubscribeEvent
    public void onScreenDrawForeground(ScreenEvent.Render.Post event) {
        DoggySpin.onScreenRenderForeground(event);
    }

    @SubscribeEvent
    public void onKeyboardInput(InputEvent.Key event) {
        this.proccessWhistle(event);
    }

    public void proccessWhistle(InputEvent.Key event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        WhistleItem whistle = DoggyItems.WHISTLE.get();
        ItemStack whistle_stack = InventoryUtil.findStackWithItemFromHands((Player)player, whistle);
        if (whistle_stack == null) {
            return;
        }
        int hotkey_use = -1;
        KeyMapping[] hotkeys_whistle = DoggyKeybinds.hotkeys_whistle;
        for (int i = 0; i < hotkeys_whistle.length; ++i) {
            if (!hotkeys_whistle[i].consumeClick()) continue;
            hotkey_use = i;
            break;
        }
        if (hotkey_use < 0) {
            return;
        }
        if (PlayerUtil.isOnCooldown((Player)player, whistle)) {
            return;
        }
        CompoundTag_1_21_5 tag = ItemUtil.getTag(whistle_stack);
        if (tag == null) {
            return;
        }
        int[] hotkeyarr = tag.getIntArray("hotkey_modes");
        if (hotkeyarr == null) {
            return;
        }
        if (hotkeyarr.length != 4) {
            return;
        }
        int mode_id = hotkeyarr[hotkey_use];
        WhistleItem.WhistleMode[] whistle_modes = WhistleItem.WhistleMode.VALUES;
        if (mode_id >= whistle_modes.length) {
            return;
        }
        if (mode_id < 0) {
            return;
        }
        WhistleItem.WhistleMode useMode = whistle_modes[mode_id];
        List dogsList = player.level().getEntitiesOfClass(Dog.class, player.getBoundingBox().inflate(100.0, 50.0, 100.0), dog -> dog.isDoingFine() && dog.isOwnedBy((LivingEntity)player));
        whistle.useMode(useMode, false, dogsList, player.level(), (Player)player, InteractionHand.MAIN_HAND, true);
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new WhistleUseData(mode_id));
    }

    public void drawSelectionBox(PoseStack matrixStackIn, Player player, float particleTicks, AABB boundingBox) {
    }

    public static void onDogMountEvent(DogMountData data) {
        Minecraft mc = Minecraft.getInstance();
        Entity e = mc.level.getEntity(data.dogId);
        LocalPlayer player = mc.player;
        if (e instanceof Dog) {
            Dog d = (Dog)e;
            if (data.mount && player != null) {
                d.startRiding((Entity)player);
            } else {
                d.stopRiding();
            }
        }
    }

    public static boolean vertifyBlockTexture(ResourceLocation loc) {
        ResourceLocation path = ClientEventHandler.getAbsoluteBlockTexture(loc);
        Optional res = Minecraft.getInstance().getResourceManager().getResource(path);
        return res.isPresent();
    }

    public static ResourceLocation getAbsoluteBlockTexture(ResourceLocation loc) {
        return Util.getResource(loc.getNamespace(), "textures/" + loc.getPath() + ".png");
    }

    public static boolean vertifyArmorTexture(ResourceLocation loc) {
        Optional res = Minecraft.getInstance().getResourceManager().getResource(loc);
        return res.isPresent();
    }

    public static boolean shouldClientBlockPick(Dog dog) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        if (!dog.isVehicle()) {
            return false;
        }
        return player.getVehicle() == dog || player.isShiftKeyDown();
    }

    public static float getAnimatedYRot(Dog dog) {
        if (dog.getAnim() == DogAnimation.NONE) {
            return 0.0f;
        }
        DogAnimation anim = dog.getAnim();
        AnimationDefinition animSeq = DogAnimationRegistry.getSequence(anim);
        if (animSeq == null) {
            return 0.0f;
        }
        DogAnimationState animState = dog.animationManager.animationState;
        float ret = DogKeyframeAnimations.getCurrentAnimatedYRot(dog, animSeq, animState.getAccumulatedTimeMillis(), 1.0f);
        if (anim.rootRotation().isPresent()) {
            Float root_rotation = anim.rootRotation().get();
            ret += root_rotation.floatValue() * ((float)Math.PI / 180);
        }
        return ret;
    }

    public static void onDogSyncedDataUpdated(DogSyncData data) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        Entity e = level.getEntity(data.dogId);
        if (!(e instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)e;
        dog.dogSyncedDataManager.updateFromDataPacketFromServer(data);
    }

    public static void onDogTalentUpdated(Dog dog) {
        Minecraft mc = Minecraft.getInstance();
        Screen screen = mc.screen;
        if (screen == null) {
            return;
        }
        if (!(screen instanceof DogNewInfoScreen)) {
            return;
        }
        DogNewInfoScreen infoScr = (DogNewInfoScreen)screen;
        if (infoScr.dog != dog) {
            return;
        }
        Store.get(infoScr).dispatch(TalentChangeHandlerSlice.class, new UIAction(UIActionTypes.Talents.TALENT_UPDATE, null));
    }

    @SubscribeEvent
    public void onPlayerLoggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
        CanineTrackerLocateRenderer.onWorldLogOut();
    }

    public static String getTranslatedVariantStr(DogVariant variant) {
        String translation_key = variant.translation();
        if (I18n.exists((String)translation_key)) {
            return I18n.get((String)translation_key, (Object[])new Object[0]);
        }
        return variant.id().toString();
    }

    public static boolean showWolfMountHealth() {
        boolean creative_hide_condition;
        if (((Boolean)ConfigHandler.CLIENT.HIDE_WOLF_MOUNT_STATUS.get()).booleanValue()) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        MultiPlayerGameMode game_mode = mc.gameMode;
        if (game_mode == null) {
            return false;
        }
        boolean bl = creative_hide_condition = !game_mode.canHurtPlayer() && (Boolean)ConfigHandler.CLIENT.HIDE_WOLF_MOUNT_STATUS_CREATIVE.get() != false;
        return !creative_hide_condition;
    }

    public static boolean shouldRenderAnimDebugNametag(Dog dog) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return false;
        }
        if (!dog.isDogInAnimDebug()) {
            return false;
        }
        ItemStack mainhand_item = player.getMainHandItem();
        if (mainhand_item == null || mainhand_item.getItem() != DoggyItems.DOG_ANIM_DEBUG.get()) {
            return false;
        }
        UUID owner_uuid = dog.getOwnerUUID();
        return owner_uuid != null && owner_uuid.equals(player.getUUID());
    }
}

