/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.AmnesiaBoneScreen.element.view.TalentView;

import doggytalents.api.registry.Talent;
import doggytalents.client.screen.AmnesiaBoneScreen.store.slice.ActiveTalentDescSlice;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.client.screen.widget.CustomButton;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogDeTrainData;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class TalentInfoViewElement
extends AbstractElement {
    Dog dog;
    Talent talent;
    Font font;
    static final int PADDING_LEFT = 5;
    static final int PADDING_RIGHT = 30;
    static final int PADDING_TOP = 5;
    static final int LINE_SPACING = 3;

    public TalentInfoViewElement(AbstractElement parent, Screen screen, Dog dog) {
        super(parent, screen);
        this.dog = dog;
        Minecraft mc = this.getScreen().getMinecraft();
        this.font = mc.font;
    }

    @Override
    public AbstractElement init() {
        Talent talent;
        this.talent = talent = this.getStateAndSubscribesTo(ActiveTalentDescSlice.class, ActiveTalentDescSlice.class, new ActiveTalentDescSlice(null)).activeTalent;
        if (this.talent == null) {
            return this;
        }
        this.addDetrainButton(this.dog);
        return this;
    }

    private void addDetrainButton(final Dog dog) {
        final int dogLevel = dog.getDogLevel(this.talent);
        var trainButton = new CustomButton(0, 0, 50, 20, (Component)Component.translatable((String)"doggui.detrain.talents.detrain"), b -> this.requestDeTrain()){

            public void renderWidgetMain(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                int costStrColor;
                Object costStr;
                int tX = this.getX();
                int n = this.getY() - 3;
                Objects.requireNonNull(TalentInfoViewElement.this.font);
                int tY = n - 9;
                int dogLevel2 = dog.getDogLevel(TalentInfoViewElement.this.talent);
                if (dogLevel2 <= 0) {
                    costStr = I18n.get((String)"doggui.detrain.talents.no_level", (Object[])new Object[0]);
                    costStrColor = -721152;
                } else {
                    costStr = I18n.get((String)"doggui.talents.cost", (Object[])new Object[0]) + TalentInfoViewElement.this.talent.getDeTrainXPCost(dogLevel2);
                    costStrColor = -1;
                }
                graphics.drawString(TalentInfoViewElement.this.font, (String)costStr, tX, tY, costStrColor);
                LocalPlayer player = Minecraft.getInstance().player;
                this.active = dogLevel2 > 0 && player != null && player.experienceLevel >= TalentInfoViewElement.this.talent.getDeTrainXPCost(dogLevel2);
            }

            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.renderWidget(graphics, mouseX, mouseY, pTicks);
                this.renderWidgetMain(graphics, mouseX, mouseY, pTicks);
                if (!this.isHovered) {
                    return;
                }
                LocalPlayer player = Minecraft.getInstance().player;
                if (this.active) {
                    return;
                }
                if (player != null && player.experienceLevel >= TalentInfoViewElement.this.talent.getDeTrainXPCost(dogLevel)) {
                    return;
                }
                MutableComponent c1 = Component.translatable((String)"doggui.detrain.talents.insufficent_xp");
                c1.setStyle(Style.EMPTY.withColor(-5111808).withBold(Boolean.valueOf(true)));
                ScreenUtil.renderComponentTooltip_21_5(graphics, TalentInfoViewElement.this.font, List.of(c1), mouseX, mouseY);
            }
        };
        LocalPlayer player = Minecraft.getInstance().player;
        trainButton.active = dogLevel > 0 && player != null && player.experienceLevel >= this.talent.getDeTrainXPCost(dogLevel);
        int trainButtonX = this.getRealX() + this.getSizeX() - trainButton.getWidth() - 35;
        int trainButtonY = this.getRealY() + this.getSizeY() - trainButton.getHeight() - 20;
        trainButton.setX(trainButtonX);
        trainButton.setY(trainButtonY);
        this.addChildren((GuiEventListener)trainButton);
    }

    private void requestDeTrain() {
        int level = this.dog.getDogLevel(this.talent);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        int xp = player.experienceLevel;
        if (level > 0 && xp >= this.talent.getDeTrainXPCost(level)) {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogDeTrainData(this.dog.getId(), this.talent));
        }
    }

    @Override
    public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.talent == null) {
            int mX = this.getSizeX() / 2;
            int mY = this.getSizeY() / 2;
            String txt = I18n.get((String)"doggui.talents.no_talents_selected", (Object[])new Object[0]);
            int tX = this.getRealX() + mX - this.font.width(txt) / 2;
            int n = this.getRealY() + mY;
            Objects.requireNonNull(this.font);
            int tY = n - 9 / 2;
            graphics.drawString(this.font, txt, tX, tY, -1);
            return;
        }
        int startX = this.getRealX() + 5;
        int startY = this.getRealY() + 5;
        int pX = startX;
        int pY = startY;
        MutableComponent title = Component.translatable((String)this.talent.getTranslationKey()).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(-721152));
        graphics.drawString(this.font, (Component)title, pX, pY, -1);
        Objects.requireNonNull(this.font);
        pY += 6 + 9;
        MutableComponent desc = Component.translatable((String)this.talent.getInfoTranslationKey());
        List desc_lines = this.font.split((FormattedText)desc, this.getSizeX() - 35);
        int lines_cnt = 0;
        for (FormattedCharSequence line : desc_lines) {
            if (lines_cnt >= 6) {
                graphics.drawString(this.font, ".. (View more in Dog's Menu)", pX, pY, -1);
                break;
            }
            graphics.drawString(this.font, line, pX, pY, -1);
            Objects.requireNonNull(this.font);
            pY += 9 + 3;
            ++lines_cnt;
        }
        startX = this.getRealX() + 5;
        pY = this.getRealY() + this.getSizeY() - 45;
        String currentLevelStr = I18n.get((String)"doggui.pointsleft", (Object[])new Object[0]);
        String currentLevelStr1 = "" + this.dog.getSpendablePoints();
        graphics.drawString(this.font, currentLevelStr, startX, pY, -1);
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, currentLevelStr1, startX, pY += 9 + 3, -1);
        startX = this.getRealX() + 80;
        pY = this.getRealY() + this.getSizeY() - 45;
        currentLevelStr = I18n.get((String)"doggui.talents.current_talent_level", (Object[])new Object[0]);
        currentLevelStr1 = this.dog.getDogLevel(this.talent) + "/" + this.talent.getMaxLevel();
        graphics.drawString(this.font, currentLevelStr, startX, pY, -1);
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, currentLevelStr1, startX, pY += 9 + 3, -1);
    }
}

