/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.StringEntrySelectScreen;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.CarryMeData;
import doggytalents.common.talent.WolfMountTalent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class CarryMeScreen
extends StringEntrySelectScreen {
    private final List<String> dogNameList = new ArrayList<String>();
    private final List<Integer> dogIdList = new ArrayList<Integer>();

    public CarryMeScreen(Player player) {
        super((Component)Component.empty());
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        List carry_me_list = level.getEntitiesOfClass(Dog.class, player.getBoundingBox().inflate(16.0, 5.0, 16.0), d -> d.isOwnedBy((LivingEntity)player) && WolfMountTalent.isValidCarryMeDog(d));
        for (Dog d2 : carry_me_list) {
            this.dogNameList.add(d2.getName().getString());
            this.dogIdList.add(d2.getId());
        }
        this.updateEntries(this.dogNameList);
    }

    public static void open(Player player) {
        Minecraft mc = Minecraft.getInstance();
        CarryMeScreen screen = new CarryMeScreen(player);
        mc.setScreen((Screen)screen);
    }

    @Override
    protected void addUtilitiesButton() {
        int mX = this.width / 2;
        int mY = this.height / 2;
        FlatButton help = new FlatButton(mX - 100 - 20 - 2, mY - 100, 20, 20, (Component)Component.literal((String)"?"), b -> {}){

            @Override
            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.renderWidget(graphics, mouseX, mouseY, pTicks);
                if (!this.isHovered) {
                    return;
                }
                ArrayList<Component> list = new ArrayList<Component>();
                list.add((Component)Component.translatable((String)"item.doggytalents.whistle.20").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
                String str = I18n.get((String)"doggytalents.screen.general.entry_select.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, CarryMeScreen.this.font));
                ScreenUtil.renderComponentTooltip_21_5(graphics, CarryMeScreen.this.font, list, mouseX, mouseY);
            }
        };
        this.addRenderableWidget((GuiEventListener)help);
    }

    @Override
    protected void onEntrySelected(int id) {
        this.requestCarryMe(this.dogIdList.get(id));
        Minecraft.getInstance().setScreen(null);
    }

    private void requestCarryMe(int id) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new CarryMeData(id));
    }
}

