/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import doggytalents.api.inferface.AbstractDog;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.LivingEntity;

public class ScreenUtil {
    public static List<Component> splitInto(String text, int maxLength, Font font) {
        ArrayList<Component> list = new ArrayList<Component>();
        StringBuilder temp = new StringBuilder();
        String[] split = text.split(" ");
        for (int i = 0; i < split.length; ++i) {
            String str = split[i];
            int length = font.width(String.valueOf(temp) + str);
            if (length > maxLength) {
                list.add((Component)Component.literal((String)temp.toString()));
                temp = new StringBuilder();
            }
            temp.append(str);
            temp.append(" ");
            if (i != split.length - 1) continue;
            list.add((Component)Component.literal((String)temp.toString()));
        }
        return list;
    }

    public static void renderEntityInInventoryFollowsMouse(GuiGraphics graphics, int dog_mX, int dog_mY, int size, float lookX, float lookY, AbstractDog dog) {
        int inflated_size = size + 60;
        lookX = (float)dog_mX - lookX;
        lookY = (float)(dog_mY -= size / 2) - lookY;
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)graphics, (int)(dog_mX - inflated_size / 2), (int)(dog_mY - inflated_size / 2), (int)(dog_mX + inflated_size / 2), (int)(dog_mY + inflated_size / 2), (int)size, (float)0.0625f, (float)lookX, (float)lookY, (LivingEntity)dog);
    }

    public static boolean shouldRemderSurvivalElement(Minecraft mc) {
        return mc.gameMode.canHurtPlayer();
    }

    public static void blit_21_3(GuiGraphics graphics, ResourceLocation texture, int x, int y, int tex_from_x, int tex_from_y, int tex_to_x, int tex_to_y) {
        graphics.blit(RenderPipelines.GUI_TEXTURED, texture, x, y, (float)tex_from_x, (float)tex_from_y, tex_to_x, tex_to_y, 256, 256);
    }

    public static void blit_21_3(GuiGraphics graphics, ResourceLocation texture, int x, int y, int a, float tex_from_x, float tex_from_y, int tex_to_x, int tex_to_y, int tex_size_x, int tex_size_y) {
        graphics.blit(RenderPipelines.GUI_TEXTURED, texture, x, y, tex_from_x, tex_from_y, tex_to_x, tex_to_y, tex_size_x, tex_size_y);
    }

    public static void renderComponentTooltip_21_5(GuiGraphics graphics, Font font, List<Component> list, int i, int j) {
        List client_components = list.stream().map(Component::getVisualOrderText).collect(Collectors.toList());
        graphics.setTooltipForNextFrame(client_components, i, j);
    }

    public static void blitColored_1_21_7(GuiGraphics graphics, ResourceLocation texture, int x, int y, float tex_from_x, float tex_from_y, int tex_to_x, int tex_to_y, int tex_size_x, int tex_size_y, float[] color) {
        int color_i = ARGB.colorFromFloat((float)color[3], (float)color[0], (float)color[1], (float)color[2]);
        graphics.blit(RenderPipelines.GUI_TEXTURED, texture, x, y, tex_from_x, tex_from_y, tex_to_x, tex_to_y, tex_to_x, tex_to_y, tex_size_x, tex_size_y, color_i);
    }

    public static void blitColored_1_21_7(GuiGraphics graphics, ResourceLocation texture, int x, int y, float tex_from_x, float tex_from_y, int tex_to_x, int tex_to_y, float[] color) {
        int color_i = ARGB.colorFromFloat((float)color[3], (float)color[0], (float)color[1], (float)color[2]);
        graphics.blit(RenderPipelines.GUI_TEXTURED, texture, x, y, tex_from_x, tex_from_y, tex_to_x, tex_to_y, tex_to_x, tex_to_y, 256, 256, color_i);
    }
}

