/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common;

import doggytalents.DoggyItems;
import doggytalents.DoggyTalents;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.block.tileentity.FoodBowlTileEntity;
import doggytalents.common.entity.Dog;
import doggytalents.common.inventory.container.DogArmorContainer;
import doggytalents.common.inventory.container.DogInventoriesContainer;
import doggytalents.common.inventory.container.DoggyToolsMenu;
import doggytalents.common.inventory.container.PackPuppyContainer;
import doggytalents.common.inventory.container.TreatBagContainer;
import doggytalents.common.util.NetworkUtil;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class Screens {
    public static void openPackPuppyScreen(ServerPlayer player, Dog dogIn) {
        if (!dogIn.canInteract((LivingEntity)player)) {
            return;
        }
        if (dogIn.isDoingFine()) {
            player.openMenu((MenuProvider)new PackPuppyContainerProvider(dogIn), buf -> buf.writeInt(dogIn.getId()));
        }
    }

    public static void openDogInventoriesScreen(ServerPlayer player, List<Dog> dogIn) {
        if (!dogIn.isEmpty()) {
            player.openMenu((MenuProvider)new DogInventoriesContainerProvider(dogIn), buf -> {
                buf.writeInt(dogIn.size());
                for (Dog dog : dogIn) {
                    buf.writeInt(dog.getId());
                }
            });
        }
    }

    public static void openFoodBowlScreen(ServerPlayer player, FoodBowlTileEntity foodBowl) {
        player.openMenu((MenuProvider)foodBowl, foodBowl.getBlockPos());
    }

    public static void openTreatBagScreen(ServerPlayer player, ItemStack stackIn, int slotId) {
        if (stackIn.getItem() == DoggyItems.TREAT_BAG.get()) {
            player.openMenu((MenuProvider)new TreatBagContainerProvider(stackIn, slotId), buf -> {
                buf.writeVarInt(slotId);
                NetworkUtil.writeItemToBuf((FriendlyByteBuf)buf, stackIn);
            });
        }
    }

    public static void openArmorScreen(ServerPlayer player, Dog dogIn) {
        if (!dogIn.canInteract((LivingEntity)player)) {
            return;
        }
        if (dogIn.isDoingFine() && dogIn.getDogLevel(DoggyTalents.DOGGY_ARMOR) > 0) {
            player.openMenu((MenuProvider)new DogArmorContainerProvider(dogIn), buf -> buf.writeInt(dogIn.getId()));
        }
    }

    public static void openDoggyToolsScreen(ServerPlayer player, Dog dogIn) {
        if (!dogIn.canInteract((LivingEntity)player)) {
            return;
        }
        if (dogIn.isDoingFine() && dogIn.getDogLevel(DoggyTalents.DOGGY_TOOLS) > 0) {
            player.openMenu((MenuProvider)new DoggyToolsMenuProvider(dogIn), buf -> buf.writeInt(dogIn.getId()));
        }
    }

    public static class PackPuppyContainerProvider
    implements MenuProvider {
        private AbstractDog dog;

        public PackPuppyContainerProvider(AbstractDog dogIn) {
            this.dog = dogIn;
        }

        public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
            return new PackPuppyContainer(windowId, inventory, this.dog);
        }

        public Component getDisplayName() {
            return Component.translatable((String)"container.doggytalents.pack_puppy");
        }
    }

    public static class DogInventoriesContainerProvider
    implements MenuProvider {
        private List<Dog> dogs;

        public DogInventoriesContainerProvider(List<Dog> dogIn) {
            this.dogs = dogIn;
        }

        public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
            return new DogInventoriesContainer(windowId, inventory, this.dogs);
        }

        public Component getDisplayName() {
            return Component.translatable((String)"container.doggytalents.dog_inventories");
        }
    }

    public static class TreatBagContainerProvider
    implements MenuProvider {
        private ItemStack stack;
        private int slotId;

        public TreatBagContainerProvider(ItemStack stackIn, int slotId) {
            this.stack = stackIn;
            this.slotId = slotId;
        }

        public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
            return new TreatBagContainer(windowId, inventory, this.slotId, this.stack);
        }

        public Component getDisplayName() {
            return Component.translatable((String)"container.doggytalents.treat_bag");
        }
    }

    public static class DogArmorContainerProvider
    implements MenuProvider {
        private Dog dog;

        public DogArmorContainerProvider(Dog dog) {
            this.dog = dog;
        }

        public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
            return new DogArmorContainer(windowId, inventory, this.dog);
        }

        public Component getDisplayName() {
            return Component.translatable((String)"container.doggytalents.dog_armor");
        }
    }

    public static class DoggyToolsMenuProvider
    implements MenuProvider {
        private Dog dog;

        public DoggyToolsMenuProvider(Dog dog) {
            this.dog = dog;
        }

        public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
            return new DoggyToolsMenu(windowId, inventory, this.dog);
        }

        public Component getDisplayName() {
            return Component.translatable((String)"container.doggytalents.doggy_tools");
        }
    }
}

