/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block;

import com.google.common.collect.Maps;
import doggytalents.DoggyTags;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.client.block.model.DogBedModel;
import doggytalents.client.event.ClientEventHandler;
import doggytalents.common.backward_imitate.DogBedHelper_21_3;
import doggytalents.common.block.BeddingMaterial;
import doggytalents.common.block.CasingMaterial;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.TagUtil;
import doggytalents.common.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.event.TagsUpdatedEvent;

public class DogBedMaterialManager {
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    public static final ResourceLocation NANI_KEY = Util.getResource("textures/block/dog_bed_nani");
    public static final ResourceLocation NANI_TEXTURE = Util.getResource("block/dog_bed_casing_nani");
    private static final Map<ResourceLocation, IBeddingMaterial> beddingMap = Maps.newConcurrentMap();
    private static final Map<ResourceLocation, ICasingMaterial> casingMap = Maps.newConcurrentMap();

    public static Map<ResourceLocation, IBeddingMaterial> getBeddings() {
        return beddingMap;
    }

    public static Map<ResourceLocation, ICasingMaterial> getCasings() {
        return casingMap;
    }

    public static IBeddingMaterial getBedding(ResourceLocation loc) {
        IBeddingMaterial ret = beddingMap.get(loc);
        if (ret == null) {
            return new NaniBedding(loc);
        }
        return ret;
    }

    public static ICasingMaterial getCasing(ResourceLocation loc) {
        ICasingMaterial ret = casingMap.get(loc);
        if (ret == null) {
            return new NaniCasing(loc);
        }
        return ret;
    }

    public static IBeddingMaterial getBedding(CompoundTag_1_21_5 tag, String id) {
        ResourceLocation loc = NBTUtil.getResourceLocation(tag, id);
        return DogBedMaterialManager.getBedding(loc);
    }

    public static ICasingMaterial getCasing(CompoundTag_1_21_5 tag, String id) {
        ResourceLocation loc = NBTUtil.getResourceLocation(tag, id);
        return DogBedMaterialManager.getCasing(loc);
    }

    public static ResourceLocation getKey(IBeddingMaterial loc) {
        ResourceLocation key = loc.getSaveKey();
        if (key == null) {
            return NANI_KEY;
        }
        return key;
    }

    public static ResourceLocation getKey(ICasingMaterial loc) {
        ResourceLocation key = loc.getSaveKey();
        if (key == null) {
            return NANI_KEY;
        }
        return key;
    }

    public static IBeddingMaterial randomBedding() {
        List list = beddingMap.entrySet().stream().filter(x -> !(x.getValue() instanceof NaniBedding)).collect(Collectors.toList());
        if (list.isEmpty()) {
            return NaniBedding.NULL;
        }
        return (IBeddingMaterial)((Map.Entry)list.get(RANDOM.nextInt(list.size()))).getValue();
    }

    public static ICasingMaterial randomCasing() {
        List list = casingMap.entrySet().stream().filter(x -> !(x.getValue() instanceof NaniCasing)).collect(Collectors.toList());
        if (list.isEmpty()) {
            return NaniCasing.NULL;
        }
        return (ICasingMaterial)((Map.Entry)list.get(RANDOM.nextInt(list.size()))).getValue();
    }

    public static void refresh(TagsUpdatedEvent.UpdateCause cause) {
        beddingMap.clear();
        casingMap.clear();
        List<Block> specific_beddings = TagUtil.queryAllValuesForTag(BuiltInRegistries.BLOCK, DoggyTags.DOG_BED_BEDDINGS);
        List<Block> specific_casings = TagUtil.queryAllValuesForTag(BuiltInRegistries.BLOCK, DoggyTags.DOG_BED_CASINGS);
        boolean specific_mode = !specific_beddings.isEmpty() && !specific_casings.isEmpty();
        DogBedMaterialManager.populateBedding(cause, specific_mode ? Optional.of(specific_beddings) : Optional.empty());
        DogBedMaterialManager.populateCasing(cause, specific_mode ? Optional.of(specific_casings) : Optional.empty());
        if (cause == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED && ((Boolean)ConfigHandler.CLIENT.DOG_BED_CLEAR_CACHE_AUTO.get()).booleanValue()) {
            DogBedModel.clearCache();
        }
    }

    private static void populateBedding(TagsUpdatedEvent.UpdateCause cause, Optional<List<Block>> specific) {
        ArrayList blocks = specific.isPresent() ? new ArrayList(specific.get()) : DogBedMaterialManager.fetchBeddingBlocksAuto();
        for (Block block : blocks) {
            if (!(block.asItem() instanceof BlockItem)) continue;
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
            IBeddingMaterial value = new BeddingMaterial(id, () -> block);
            if (cause == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED && !ClientEventHandler.vertifyBlockTexture(value.getTexture())) {
                value = new NaniBedding(id);
            }
            beddingMap.put(id, value);
        }
    }

    private static void populateCasing(TagsUpdatedEvent.UpdateCause cause, Optional<List<Block>> specific) {
        ArrayList blocks = specific.isPresent() ? new ArrayList(specific.get()) : DogBedMaterialManager.fetchCasingBlocksAuto();
        for (Block block : blocks) {
            if (!(block.asItem() instanceof BlockItem)) continue;
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
            ICasingMaterial value = new CasingMaterial(id, () -> block);
            if (cause == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED && !ClientEventHandler.vertifyBlockTexture(value.getTexture())) {
                value = new NaniCasing(id);
            }
            casingMap.put(id, value);
        }
    }

    private static List<Block> fetchCasingBlocksAuto() {
        List planks = TagUtil.queryAllValuesForTag(BuiltInRegistries.BLOCK, BlockTags.PLANKS);
        List<Block> logs = DogBedHelper_21_3.excludeWoodBlocksFromList(TagUtil.queryAllValuesForTag(BuiltInRegistries.BLOCK, BlockTags.LOGS));
        ArrayList<Block> ret = new ArrayList<Block>(planks.size() + logs.size());
        ret.addAll(planks);
        ret.addAll(logs);
        return ret;
    }

    private static List<Block> fetchBeddingBlocksAuto() {
        List wools = TagUtil.queryAllValuesForTag(BuiltInRegistries.BLOCK, BlockTags.WOOL);
        ArrayList<Block> ret = new ArrayList<Block>(wools.size());
        ret.addAll(wools);
        return ret;
    }

    public static void onTagsUpdated(TagsUpdatedEvent event) {
        DogBedMaterialManager.refresh(event.getUpdateCause());
    }

    public static class NaniBedding
    extends IBeddingMaterial {
        public static final NaniBedding NULL = new NaniBedding(null);
        private Optional<ResourceLocation> missingLoc;

        public NaniBedding(ResourceLocation loc) {
            this.missingLoc = loc == null ? Optional.empty() : Optional.of(loc);
        }

        @Override
        public ResourceLocation getTexture() {
            return NANI_TEXTURE;
        }

        @Override
        public Component getTooltip() {
            String retStr = "nani?";
            if (this.missingLoc.isPresent()) {
                retStr = this.missingLoc.get().toString();
            }
            return Component.translatable((String)retStr).withStyle(ChatFormatting.RED);
        }

        @Override
        public Optional<Ingredient> getIngredient() {
            return Optional.empty();
        }

        public Optional<ResourceLocation> missingLoc() {
            return this.missingLoc;
        }

        @Override
        public boolean isNani() {
            return true;
        }

        @Override
        public ResourceLocation getSaveKey() {
            return this.missingLoc().orElse(null);
        }
    }

    public static class NaniCasing
    extends ICasingMaterial {
        public static final NaniCasing NULL = new NaniCasing(null);
        private Optional<ResourceLocation> missingLoc;

        public NaniCasing(ResourceLocation loc) {
            this.missingLoc = loc == null ? Optional.empty() : Optional.of(loc);
        }

        @Override
        public ResourceLocation getTexture() {
            return NANI_TEXTURE;
        }

        @Override
        public Component getTooltip() {
            String retStr = "nani?";
            if (this.missingLoc.isPresent()) {
                retStr = this.missingLoc.get().toString();
            }
            return Component.translatable((String)retStr).withStyle(ChatFormatting.RED);
        }

        @Override
        public Optional<Ingredient> getIngredient() {
            return Optional.empty();
        }

        public Optional<ResourceLocation> missingLoc() {
            return this.missingLoc;
        }

        @Override
        public ResourceLocation getSaveKey() {
            return this.missingLoc().orElse(null);
        }

        @Override
        public boolean isNani() {
            return true;
        }
    }
}

