/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.DogSounds;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogPose;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;

public class DogFeelingNakeyGoal
extends Goal {
    private Dog dog;
    private boolean prevNaked = true;
    private boolean turnedNaked = false;
    private int updateInterval = 60;
    private int lastUpdateTick;
    private int stopTick;
    private int tickAnim;

    public DogFeelingNakeyGoal(Dog dog) {
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        this.dog = dog;
    }

    public boolean canUse() {
        this.findOutIfTurningToNakid();
        if (!this.dog.isOrderedToSit()) {
            return false;
        }
        if (this.dog.getDogPose() != DogPose.SIT) {
            return false;
        }
        if (!this.dog.canDoIdileAnim()) {
            return false;
        }
        if (!this.dog.onGround()) {
            return false;
        }
        return this.turnedNaked && this.isNaked(this.dog);
    }

    public boolean canContinueToUse() {
        if (!this.dog.isOrderedToSit()) {
            return false;
        }
        if (this.dog.getDogPose() != DogPose.SIT) {
            return false;
        }
        if (!this.dog.canContinueDoIdileAnim()) {
            return false;
        }
        if (!this.dog.onGround()) {
            return false;
        }
        if (!this.isNaked(this.dog)) {
            return false;
        }
        return this.dog.tickCount < this.stopTick;
    }

    public void start() {
        this.turnedNaked = false;
        DogAnimation currentAnimation = DogAnimation.NAKEY;
        this.stopTick = this.dog.tickCount + currentAnimation.getLengthTicks();
        this.dog.setAnimForIdle(currentAnimation);
        this.tickAnim = 0;
    }

    public void tick() {
        if (this.tickAnim == 67) {
            this.dog.playSound(DogSounds.CLASSIC_WHINE.get(), this.dog.getSoundVolume(), this.dog.getVoicePitch());
        }
        ++this.tickAnim;
    }

    public void stop() {
        if (this.dog.getAnim() == DogAnimation.NAKEY) {
            this.dog.setAnim(DogAnimation.NONE);
        }
    }

    private void findOutIfTurningToNakid() {
        int updateAtTick = this.lastUpdateTick + this.updateInterval;
        if (this.dog.tickCount < updateAtTick) {
            return;
        }
        this.lastUpdateTick = this.dog.tickCount;
        boolean naked = this.isNaked(this.dog);
        if (!naked) {
            this.turnedNaked = false;
        }
        if (naked && !this.prevNaked) {
            this.turnedNaked = this.dog.getRandom().nextFloat() <= 0.9f;
        }
        this.updateInterval = naked ? (5 + this.dog.getRandom().nextInt(21)) * 20 : (1 + this.dog.getRandom().nextInt(3)) * 20;
        this.prevNaked = naked;
    }

    private boolean isNaked(Dog dog) {
        List<AccessoryInstance> accessories;
        if (!dog.hideArmor()) {
            Iterable<ItemStack> armors = dog.getArmorSlots();
            boolean hasArmor = false;
            for (ItemStack s : armors) {
                if (s.isEmpty()) continue;
                hasArmor = true;
                break;
            }
            if (hasArmor) {
                return false;
            }
            if (dog.hasWolfArmor()) {
                return false;
            }
        }
        if ((accessories = dog.getAccessories()).isEmpty()) {
            return true;
        }
        boolean hasNonNaked = false;
        for (AccessoryInstance x : accessories) {
            Accessory accessory = x.getAccessory();
            if (accessory.isDogStillNakedWhenWear()) continue;
            hasNonNaked = true;
            break;
        }
        return !hasNonNaked;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

