/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.DoggyTalents;
import doggytalents.api.feature.DogMode;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.phys.AABB;

public class GuardModeGoal
extends NearestAttackableTargetGoal<Mob> {
    private final Dog dog;
    private LivingEntity owner;
    private static final int GUARD_DISTANCE = 6;
    private static final int GUARD_DISTANCE_SQR = 36;
    private static final int START_FOLLOW_DISTANCE_SQR = 6;
    private static final int STOP_FOLLOW_DISTANCE_SQR = 4;

    public GuardModeGoal(Dog dog) {
        super((Mob)dog, Mob.class, 3, false, false, (e, level) -> e instanceof Enemy);
        this.dog = dog;
    }

    public boolean canUse() {
        this.owner = this.dog.getOwner();
        if (this.owner == null) {
            return false;
        }
        if (!this.dog.isMode(DogMode.GUARD, DogMode.GUARD_FLAT)) {
            return false;
        }
        return super.canUse();
    }

    protected double getFollowDistance() {
        return 12.0f * Mth.SQRT_OF_TWO + 1.0f;
    }

    protected void findTarget() {
        this.target = ((ServerLevel)this.dog.level()).getNearestEntity(this.targetType, this.targetConditions, (LivingEntity)this.dog, this.owner.getX(), this.owner.getEyeY(), this.owner.getZ(), this.getTargetSearchArea(6.0));
    }

    public void stop() {
        this.owner = null;
    }

    public static class Major
    extends Goal {
        private final Dog dog;
        private LivingEntity owner;
        private int tickUntilPathRecalc = 0;

        public Major(Dog dog) {
            this.dog = dog;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (!this.dog.isMode(DogMode.GUARD, DogMode.GUARD_FLAT)) {
                return false;
            }
            if (this.dog.isLowHunger()) {
                return false;
            }
            this.owner = this.dog.getOwner();
            if (this.owner == null) {
                return false;
            }
            LivingEntity target = this.dog.getTarget();
            return target == null || !(target.distanceToSqr((Entity)this.owner) <= 36.0);
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }

        public void tick() {
            double dist_owner_sqr = this.dog.distanceToSqr((Entity)this.owner);
            if (this.tickUntilPathRecalc > 0) {
                --this.tickUntilPathRecalc;
            }
            if (dist_owner_sqr >= 6.0 && this.tickUntilPathRecalc <= 0) {
                this.tickUntilPathRecalc = 5;
                if (!this.dog.isLeashed() && !this.dog.isPassenger()) {
                    if (this.dog.distanceToSqr((Entity)this.owner) > 36.0) {
                        DogUtil.guessAndTryToTeleportToOwner(this.dog, this.owner, 4);
                    } else {
                        float speed = dist_owner_sqr <= 9.0 ? 1.0f : this.dog.getUrgentSpeedModifier();
                        this.dog.getNavigation().moveTo((Entity)this.owner, (double)speed);
                    }
                }
            }
            if (dist_owner_sqr < 4.0) {
                this.dog.breakMoveControl();
                this.dog.getNavigation().stop();
            }
        }

        public void stop() {
            this.owner = null;
        }
    }

    public static class Minor
    extends Goal {
        private final Dog dog;
        private LivingEntity owner;
        private LivingEntity nearestDanger;
        private int searchTimestamp = 0;
        private int growlCoolDownEnd = 0;
        private int tickUntilPathRecalc = 0;
        private final int SEARCH_RADIUS = 6;

        public Minor(Dog dog) {
            this.dog = dog;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (!this.dog.isMode(DogMode.GUARD_MINOR)) {
                return false;
            }
            if (this.dog.isLowHunger()) {
                return false;
            }
            this.owner = this.dog.getOwner();
            return this.owner != null;
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }

        public void start() {
        }

        public void tick() {
            if (this.nearestDanger != null) {
                this.dog.getLookControl().setLookAt((Entity)this.nearestDanger, 10.0f, (float)this.dog.getMaxHeadXRot());
            }
            double dist_owner_sqr = this.dog.distanceToSqr((Entity)this.owner);
            if (this.tickUntilPathRecalc > 0) {
                --this.tickUntilPathRecalc;
            }
            if (dist_owner_sqr >= 6.0 && this.tickUntilPathRecalc <= 0) {
                this.tickUntilPathRecalc = 5;
                if (!this.dog.isLeashed() && !this.dog.isPassenger()) {
                    if (this.dog.distanceToSqr((Entity)this.owner) > 36.0) {
                        DogUtil.guessAndTryToTeleportToOwner(this.dog, this.owner, 4);
                    } else {
                        float speed = dist_owner_sqr <= 9.0 ? 1.0f : this.dog.getUrgentSpeedModifier();
                        this.dog.getNavigation().moveTo((Entity)this.owner, (double)speed);
                    }
                }
            }
            if (dist_owner_sqr < 4.0) {
                this.dog.breakMoveControl();
                this.dog.getNavigation().stop();
            }
            if (this.dog.tickCount >= this.searchTimestamp) {
                int max_timestamp;
                this.searchTimestamp = this.dog.tickCount + 10;
                boolean wasSafe = this.nearestDanger == null;
                this.findDanger();
                if (this.nearestDanger != null && wasSafe && this.growlCoolDownEnd > (max_timestamp = this.dog.tickCount + 20)) {
                    this.growlCoolDownEnd = max_timestamp;
                }
            }
            if (this.nearestDanger != null && this.dog.tickCount >= this.growlCoolDownEnd) {
                this.growlCoolDownEnd = this.dog.tickCount + 50;
                SoundEvent sound = this.dog.dogMood.getSeriousGrowl();
                this.dog.playSound(sound, 1.0f, (this.dog.getRandom().nextFloat() - this.dog.getRandom().nextFloat()) * 0.2f + 1.0f);
            }
        }

        protected void findDanger() {
            if (this.dog.getDogLevel(DoggyTalents.RESCUE_DOG) > 0) {
                return;
            }
            this.nearestDanger = ((ServerLevel)this.dog.level()).getNearestEntity(Mob.class, TargetingConditions.forCombat().selector((target, level) -> {
                if (this.dog.getDogLevel(DoggyTalents.CREEPER_SWEEPER) > 0) {
                    return target instanceof Creeper;
                }
                return target instanceof Enemy;
            }), (LivingEntity)this.dog, this.owner.getX(), this.owner.getEyeY(), this.owner.getZ(), new AABB(this.owner.blockPosition()).inflate(6.0, 4.0, 6.0));
        }

        public void stop() {
            this.owner = null;
        }
    }
}

