/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.nav;

import doggytalents.common.entity.Dog;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DogMoveControl
extends MoveControl {
    private static final float SNEAK_SPEED_1 = 0.35f;
    private static final float SNEAK_SPEED_2 = 0.25f;
    private Dog dog;
    private float forceSneak = -1.0f;

    public DogMoveControl(Dog dog) {
        super((Mob)dog);
        this.dog = dog;
    }

    public void tick() {
        if (this.operation == MoveControl.Operation.MOVE_TO) {
            this.operation = MoveControl.Operation.WAIT;
            this.doDogMoveTo();
            this.forceSneak = -1.0f;
            return;
        }
        if (this.operation == MoveControl.Operation.STRAFE) {
            this.operation = MoveControl.Operation.WAIT;
            this.doDogStrafe();
            return;
        }
        super.tick();
    }

    public void forceSneak(float val) {
        this.forceSneak = val;
    }

    private void doDogMoveTo() {
        boolean shouldJump;
        double dx = this.wantedX - this.dog.getX();
        double dz = this.wantedZ - this.dog.getZ();
        double dy = this.wantedY - this.dog.getY();
        double l_sqr = dx * dx + dy * dy + dz * dz;
        if (l_sqr < 2.500000277905201E-7) {
            this.dog.setZza(0.0f);
            return;
        }
        double base_speed = this.dog.getAttributeValue((Holder<Attribute>)Attributes.MOVEMENT_SPEED);
        double speed = base_speed * this.speedModifier;
        double dy_abs = Math.abs(dy);
        if (dy_abs > 0.75) {
            double speed_cap = dy_abs > 1.75 ? 0.25 : (double)0.35f;
            speed = Math.min(speed, speed_cap);
        }
        if (this.dog.isDogCurious()) {
            speed = Math.min(speed, 0.25);
        }
        if (this.forceSneak > 0.0f) {
            speed = Math.min(speed, (double)this.forceSneak);
        }
        float target_yrot = (float)(Mth.atan2((double)dz, (double)dx) * 57.2957763671875 - 90.0);
        float apporaching_yrot = speed < (double)0.39f ? this.rotlerp(this.dog.getYRot(), target_yrot, 90.0f) : target_yrot;
        this.dog.setYRot(apporaching_yrot);
        this.dog.setSpeed((float)speed);
        BlockPos b0 = this.dog.blockPosition();
        BlockState b0_state = this.dog.level().getBlockState(b0);
        VoxelShape b0_collision = b0_state.getCollisionShape((BlockGetter)this.dog.level(), b0);
        boolean dyRequiresJump = dy > (double)this.dog.maxUpStep() && dx * dx + dz * dz < (double)Math.max(1.0f, this.dog.getBbWidth());
        boolean collisionRequireJump = !b0_collision.isEmpty() && this.dog.getY() < b0_collision.max(Direction.Axis.Y) + (double)b0.getY() && !b0_state.is(BlockTags.DOORS) && !b0_state.is(BlockTags.FENCES) && !(b0_state.getBlock() instanceof FenceGateBlock);
        boolean bl = shouldJump = dyRequiresJump || collisionRequireJump;
        if (shouldJump) {
            this.dog.setYRot(target_yrot);
            this.dog.getJumpControl().jump();
            this.operation = MoveControl.Operation.JUMPING;
        }
    }

    private void doDogStrafe() {
        float check_z;
        float speed = (float)this.dog.getAttributeValue((Holder<Attribute>)Attributes.MOVEMENT_SPEED);
        speed *= (float)this.speedModifier;
        float check_formard = this.strafeForwards;
        float check_right = this.strafeRight;
        float check_length = Mth.sqrt((float)(check_formard * check_formard + check_right * check_right));
        if (check_length > 1.0f) {
            check_formard /= check_length;
            check_right /= check_length;
        }
        float yrot_x = Mth.sin((float)(this.dog.getYRot() * ((float)Math.PI / 180)));
        float yrot_z = Mth.cos((float)(this.dog.getYRot() * ((float)Math.PI / 180)));
        float check_x = (check_right *= speed) * yrot_z + (check_formard *= speed) * -yrot_x;
        if (!this.isWalkableStrafe(check_x, check_z = check_right * yrot_x + check_formard * yrot_z)) {
            this.dog.setSpeed(0.0f);
            this.dog.setZza(0.0f);
            this.dog.setXxa(0.0f);
            return;
        }
        this.mob.setSpeed(speed);
        this.mob.setZza(this.strafeForwards);
        this.mob.setXxa(this.strafeRight);
    }

    private boolean isWalkableStrafe(float dx, float dz) {
        PathNavigation nav = this.dog.getNavigation();
        if (nav == null) {
            return false;
        }
        NodeEvaluator node_eval = nav.getNodeEvaluator();
        if (node_eval == null) {
            return false;
        }
        BlockPos check_pos = BlockPos.containing((double)(this.dog.getX() + (double)dx), (double)this.mob.getBlockY(), (double)(this.mob.getZ() + (double)dz));
        boolean is_walkable = node_eval.getPathType((Mob)this.dog, check_pos) == PathType.WALKABLE;
        return is_walkable;
    }
}

