/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.PlayerUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;

public class DogGreetOwnerAction
extends TriggerableAction {
    private LivingEntity owner;
    private static final int GREET_TICK_PER_LEFT_DAY = 20;
    private static final int MAX_GREET_TIME = 400;
    private static final int MAY_CANCEL_GREET_TIME = 100;
    private static final int START_GREET_DISTANCE_SQR = 4;
    private static final int GREET_RADIUS = 1;
    private static final int JUMP_BASE_INTERVAL = 7;
    private static final int WHINE_BASE_INTERVAL = 50;
    private static final int HEART_CHANCE_WINDOW = 8;
    private static final float MSG_CHANCE = 0.75f;
    private int greetTime;
    private int tickTillPathRecalc;
    private BlockPos rbAroundOwner;
    private int tickTillWhine;
    private int tickTillJump;
    private boolean tellOwner;
    private boolean isDoingAnim = false;
    private final int greetStopTime;

    public DogGreetOwnerAction(Dog dog, @Nonnull LivingEntity owner, long ownerLeftInterval) {
        super(dog, true, true);
        this.owner = owner;
        this.greetStopTime = this.calculateGreetTime(ownerLeftInterval);
    }

    private int calculateGreetTime(long ownerLeftInterval) {
        int a = Mth.floor((float)(ownerLeftInterval / 24000L * 20L));
        return Math.min(a, 400);
    }

    @Override
    public void onStart() {
        this.tickTillPathRecalc = 0;
        this.greetTime = 0;
        this.tickTillWhine = this.dog.getRandom().nextInt(5) * 10;
        this.tellOwner = true;
        this.dog.dogSoundManager.setAmbientLocked(true);
    }

    @Override
    public void tick() {
        if (this.greetTime >= this.greetStopTime && !this.isDoingAnim) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (!this.owner.isAlive() || this.owner.isSpectator()) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        double d0 = this.dog.distanceToSqr((Entity)this.owner);
        this.dog.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.dog.getMaxHeadXRot());
        if (d0 > 4.0 && !this.isDoingAnim) {
            this.doGoToOwner();
        } else {
            this.tellOwner();
            this.doGreet();
        }
    }

    private void doGoToOwner() {
        if (--this.tickTillPathRecalc <= 0) {
            this.tickTillPathRecalc = 20;
            DogUtil.moveToOwnerOrTeleportIfFarAway(this.dog, this.owner, this.dog.getUrgentSpeedModifier(), 400.0, false, false, 400.0, this.dog.getMaxFallDistance());
        }
    }

    private void tellOwner() {
        if (!this.tellOwner) {
            return;
        }
        this.tellOwner = false;
        float r = this.dog.getRandom().nextFloat();
        if (r >= 0.75f) {
            return;
        }
        int MSG_COUNT = 5;
        float msg_id_step = 0.15f;
        int msg_id = Mth.floor((float)(r / msg_id_step));
        msg_id = Mth.clamp((int)msg_id, (int)0, (int)4);
        PlayerUtil.sendSystemMessage(this.owner, (Component)Component.translatable((String)("dog.msg.greet_owner." + msg_id), (Object[])new Object[]{this.dog.getName().getString()}));
    }

    private void doGreet() {
        Level level;
        ++this.greetTime;
        if (this.isDoingAnim) {
            this.tickAnim();
        } else {
            this.jumpOrDoAnim();
        }
        if (!this.isDoingAnim) {
            this.runAround();
        }
        if (--this.tickTillWhine <= 0) {
            this.tickTillWhine = 50 + this.dog.getRandom().nextInt(3) * 20;
            SoundEvent sound = this.dog.dogMood.getGreetWhine();
            this.dog.dogSoundManager.playInterruptible(sound, this.dog.getSoundVolume(), this.dog.getVoicePitch());
        }
        if (this.dog.getRandom().nextInt(8) == 0 && (level = this.dog.level()) instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            sLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, this.dog.getX(), this.dog.getY(), this.dog.getZ(), 1, (double)this.dog.getBbWidth(), (double)0.8f, (double)this.dog.getBbWidth(), 0.1);
        }
    }

    private void runAround() {
        PathNavigation n = this.dog.getNavigation();
        if (n.isDone() && this.dog.tickCount % 2 != 0) {
            this.rbAroundOwner = this.getRandomPosAroundOwner(this.owner);
            n.moveTo((double)this.rbAroundOwner.getX(), (double)this.rbAroundOwner.getY(), (double)this.rbAroundOwner.getZ(), 1.0);
        }
    }

    private void jumpOrDoAnim() {
        if (this.tickTillJump > 0) {
            --this.tickTillJump;
        }
        if (!this.canJump()) {
            return;
        }
        if (this.tickTillJump <= 0) {
            this.tickTillJump = 7;
            if (this.canDoAnimInsteadOfJump() && this.dog.getRandom().nextFloat() <= 0.7f) {
                this.startDoingAnim();
            } else {
                this.dog.getJumpControl().jump();
            }
        }
    }

    private void startDoingAnim() {
        this.isDoingAnim = true;
        this.dog.getNavigation().stop();
        this.dog.setAnim(DogAnimation.GREET);
    }

    private void tickAnim() {
        if (this.dog.getAnim() != DogAnimation.GREET) {
            this.isDoingAnim = false;
        }
    }

    private boolean canJump() {
        return this.dog.onGround();
    }

    private boolean canDoAnimInsteadOfJump() {
        if (this.dog.distanceToSqr((Entity)this.owner) > 2.25) {
            return false;
        }
        double dy = this.owner.getEyeY() - this.dog.getEyeY();
        return !(dy < 0.3);
    }

    @Override
    public void onStop() {
        if (this.isStarted() && this.dog.getAnim() == DogAnimation.GREET) {
            this.dog.setAnim(DogAnimation.NONE);
        }
        this.dog.dogOwnerDistanceManager.onGreetingActionStop(this.owner);
        this.dog.dogSoundManager.setAmbientLocked(false);
    }

    @Override
    public void onDogGoesOfflineWhileActive() {
        this.dog.dogOwnerDistanceManager.onGreetingActionStop(this.owner);
    }

    @Override
    public boolean canOverrideSit() {
        return true;
    }

    @Override
    public boolean canPreventSit() {
        return this.greetTime < 100;
    }

    private BlockPos getRandomPosAroundOwner(LivingEntity owner) {
        BlockPos owner_b0 = owner.blockPosition();
        RandomSource r = owner.getRandom();
        int rX = r.nextIntBetweenInclusive(-1, 1);
        int rY = r.nextIntBetweenInclusive(-1, 1);
        int rZ = r.nextIntBetweenInclusive(-1, 1);
        return owner_b0.offset(rX, rY, rZ);
    }
}

