/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.event;

import doggytalents.common.backward_imitate.DataUtil_1_21_9;
import doggytalents.common.lib.Resources;
import doggytalents.common.util.Util;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.BuiltInPackSource;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforgespi.language.IModInfo;

public class PackHandler {
    public static final String BUILTIN_PREFIX = "mod/" + String.valueOf(Util.getResource("builtin"));
    public static final String ALT_RECIPE_1 = "alt_recipe_1";

    public static void onAddPackFinder(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            event.addRepositorySource(PackHandler::onRegisterServerPack);
        }
    }

    private static void onRegisterServerPack(Consumer<Pack> pack_consumer) {
        PackHandler.findAndCreatePack(PackType.SERVER_DATA, ALT_RECIPE_1, (Component)Component.literal((String)"DTN Recipe Pack I."), PackSource.FEATURE, false, Pack.Position.TOP).ifPresent(pack_consumer::accept);
    }

    public static String getBuiltinPackLocationNamespace(String id) {
        return "data/doggytalents/datapacks/" + id;
    }

    public static Optional<ResourceLocation> onPackLoadIcon(Pack pack) {
        String pack_id = pack.getId();
        if (PackHandler.isBuiltinPack(pack_id)) {
            return Optional.of(Resources.DTN_PACK_ICON);
        }
        return Optional.empty();
    }

    private static Optional<Pack> findAndCreatePack(PackType type, String id, Component display_name, PackSource source, boolean always_active, Pack.Position position) {
        String mod_path = PackHandler.getBuiltinPackLocationNamespace(id);
        IModInfo mod_info = ((ModContainer)ModList.get().getModContainerById("doggytalents").orElseThrow()).getModInfo();
        String version = mod_info.getVersion().toString();
        KnownPack known_pack_info = new KnownPack("doggytalents", id, version);
        PackLocationInfo pack_location_info = new PackLocationInfo(BUILTIN_PREFIX + "/" + id, display_name, source, Optional.of(known_pack_info));
        Pack pack = Pack.readMetaAndCreate((PackLocationInfo)pack_location_info, (Pack.ResourcesSupplier)BuiltInPackSource.fromName(DataUtil_1_21_9.getPackResourceSupplier(mod_info, mod_path)), (PackType)type, (PackSelectionConfig)new PackSelectionConfig(always_active, position, false));
        return Optional.ofNullable(pack);
    }

    public static boolean isBuiltinPack(String id) {
        return id != null && id.startsWith(BUILTIN_PREFIX);
    }
}

