/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.WhisltleEditHotKeyData;
import doggytalents.common.util.ItemUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class WhistleEditHotKeyPacket
implements IPacket<WhisltleEditHotKeyData> {
    @Override
    public void encode(WhisltleEditHotKeyData data, FriendlyByteBuf buf) {
        buf.writeInt(data.hotkey_id);
        buf.writeInt(data.new_mode_id);
    }

    @Override
    public WhisltleEditHotKeyData decode(FriendlyByteBuf buf) {
        int hotkey_id = buf.readInt();
        int new_mode_id = buf.readInt();
        return new WhisltleEditHotKeyData(hotkey_id, new_mode_id);
    }

    @Override
    public void handle(WhisltleEditHotKeyData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            int[] keyarr;
            if (!((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isServerRecipent()) {
                return;
            }
            ServerPlayer player = ((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
            ItemStack stack = player.getMainHandItem();
            if (stack.getItem() != DoggyItems.WHISTLE.get()) {
                return;
            }
            CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
            if (!tag.contains("hotkey_modes", 11)) {
                tag.putIntArray("hotkey_modes", new int[]{-1, -1, -1, -1});
                ItemUtil.putTag(stack, tag);
            }
            if ((keyarr = tag.getIntArray("hotkey_modes")) == null) {
                return;
            }
            if (keyarr.length != 4) {
                tag.putIntArray("hotkey_modes", new int[]{-1, -1, -1, -1});
                ItemUtil.putTag(stack, tag);
                return;
            }
            if (data.hotkey_id >= keyarr.length) {
                return;
            }
            if (data.hotkey_id < 0) {
                return;
            }
            if (data.new_mode_id >= 0) {
                for (int i : keyarr) {
                    if (i != data.new_mode_id) continue;
                    return;
                }
            }
            keyarr[data.hotkey_id] = data.new_mode_id;
            tag.putIntArray("hotkey_modes", keyarr);
            ItemUtil.putTag(stack, tag);
        });
        ctx.get().setPacketHandled(true);
    }
}

