/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.util.EntityUtil;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.npc.Villager;

public class PuppyEyesTalent
extends TalentInstance {
    private int cooldown;

    public PuppyEyesTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
        this.cooldown = dogIn.tickCount;
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        int timeLeft = this.cooldown - dogIn.tickCount;
        compound.putInt("cooldown", timeLeft);
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag_1_21_5 compound) {
        super.readFromNBT(dogIn, compound);
        this.cooldown = dogIn.tickCount + compound.getInt("cooldown");
    }

    @Override
    public void livingTick(AbstractDog dogIn) {
        this.tickGainReputation(dogIn);
    }

    public void tickGainReputation(AbstractDog dog) {
        if (dog.tickCount % 40 != 0) {
            return;
        }
        if (dog.level().isClientSide) {
            return;
        }
        if (this.level() <= 0) {
            return;
        }
        int timeLeft = this.cooldown - dog.tickCount;
        if (timeLeft > 0) {
            return;
        }
        LivingEntity owner = dog.getOwner();
        if (owner == null) {
            return;
        }
        Villager villager = this.getClosestVisibleVillager(dog, 5.0);
        if (villager == null) {
            return;
        }
        int add_val = this.level() * 20;
        villager.getGossips().add(owner.getUUID(), GossipType.MINOR_POSITIVE, add_val);
        this.cooldown = dog.tickCount + (this.level() >= 5 ? 24000 : 48000);
    }

    public Villager getClosestVisibleVillager(AbstractDog dogIn, double radiusIn) {
        List list = dogIn.level().getEntitiesOfClass(Villager.class, dogIn.getBoundingBox().inflate(radiusIn, radiusIn, radiusIn), village -> village.getSensing().hasLineOfSight((Entity)dogIn));
        return (Villager)EntityUtil.getClosestTo((Entity)dogIn, list);
    }
}

