/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.feature;

import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.api.inferface.IDogFoodPredicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class FoodHandler {
    private static final List<IDogFoodHandler> commonHandlers = new ArrayList<IDogFoodHandler>(4);

    public static synchronized void registerHandler(IDogFoodHandler handler) {
        commonHandlers.add(handler);
    }

    public static Optional<IDogFoodPredicate> isFood(ItemStack stackIn) {
        return FoodHandler.isFood(stackIn, null);
    }

    public static Optional<IDogFoodPredicate> isFood(ItemStack stackIn, @Nullable AbstractDog dog) {
        if (dog != null) {
            for (IDogFoodHandler handler : dog.getFoodHandlers()) {
                if (!handler.isFood(stackIn)) continue;
                return Optional.of(handler);
            }
        }
        if (stackIn.getItem() instanceof IDogFoodHandler && ((IDogFoodHandler)stackIn.getItem()).isFood(stackIn)) {
            return Optional.of((IDogFoodHandler)stackIn.getItem());
        }
        for (IDogFoodHandler handler : commonHandlers) {
            if (!handler.isFood(stackIn)) continue;
            return Optional.of(handler);
        }
        return Optional.empty();
    }

    public static Optional<IDogFoodHandler> getMatch(@Nullable AbstractDog dogIn, ItemStack stackIn, @Nullable Entity entityIn) {
        if (dogIn == null) {
            return Optional.empty();
        }
        for (IDogFoodHandler handler : dogIn.getFoodHandlers()) {
            if (!handler.canConsume(dogIn, stackIn, entityIn)) continue;
            return Optional.of(handler);
        }
        if (stackIn.getItem() instanceof IDogFoodHandler && ((IDogFoodHandler)stackIn.getItem()).canConsume(dogIn, stackIn, entityIn)) {
            return Optional.of((IDogFoodHandler)stackIn.getItem());
        }
        for (IDogFoodHandler handler : commonHandlers) {
            if (!handler.canConsume(dogIn, stackIn, entityIn)) continue;
            return Optional.of(handler);
        }
        return Optional.empty();
    }
}

