/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.block.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import doggytalents.client.entity.model.animation.DogKeyframeAnimations;
import doggytalents.client.entity.model.animation.SimpleAnimatedModel;
import doggytalents.common.block.tileentity.RiceMillBlockEntity;
import doggytalents.common.util.Util;
import java.util.Optional;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import org.joml.Vector3f;

public class RiceMillModel
extends SimpleAnimatedModel {
    private ModelPart root;
    private ModelPart spin;
    private ModelPart hammer;
    private Vector3f tempVec = new Vector3f();
    private static final AnimationDefinition GRIND_ANIM = AnimationDefinition.Builder.withLength((float)10.0f).looping().addAnimation("spin", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(10.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)360.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("hammer_lever2", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(2.5f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(5.0f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(7.5f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("hammer_lever2", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.9f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-27.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.2f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)2.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(2.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(3.4f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-27.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(3.7f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)2.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(5.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(5.9f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-27.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(6.2f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)2.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(7.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(8.4f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-27.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(8.7f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)2.5f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("hammer_head2", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.9f, KeyframeAnimations.posVec((float)0.0f, (float)1.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.2f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(2.5f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(3.4f, KeyframeAnimations.posVec((float)0.0f, (float)1.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(3.7f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(5.0f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(5.9f, KeyframeAnimations.posVec((float)0.0f, (float)1.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(6.2f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(7.5f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(8.4f, KeyframeAnimations.posVec((float)0.0f, (float)1.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(8.7f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("hammer_head2", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.9f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.2f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(2.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(3.4f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(3.7f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(5.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(5.9f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(6.2f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(7.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(8.4f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(8.7f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).build();

    public RiceMillModel(ModelPart box) {
        super(RenderType::entityCutoutNoCull);
        this.root = box;
        this.spin = box.getChild("spin");
        this.hammer = box.getChild("hammer2");
    }

    @Override
    public Optional<ModelPart> getPartFromName(String name) {
        if ("spin".equals(name)) {
            return Optional.of(this.spin);
        }
        if (this.hammer.hasChild(name)) {
            return Optional.of(this.hammer.getChild(name));
        }
        return Optional.empty();
    }

    @Override
    public void resetPart(ModelPart part) {
        part.resetPose();
    }

    @Override
    public void resetAllPose() {
        this.spin.resetPose();
        this.hammer.getAllParts().forEach(x -> x.resetPose());
    }

    public void setUpMillAnim(RiceMillBlockEntity mill, float pTicks) {
        if (!mill.isSpinning()) {
            pTicks = 0.0f;
        }
        double timeLine = (double)((float)mill.getAnimationTick() + pTicks) % 200.0;
        long timeLineMillis = Util.tickMayWithPartialToMillis(timeLine);
        DogKeyframeAnimations.animateSimple(this, GRIND_ANIM, timeLineMillis, 1.0f, this.tempVec);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition stand = partdefinition.addOrReplaceChild("stand", CubeListBuilder.create().texOffs(38, 55).addBox(-9.0f, -6.25f, -0.5f, 2.0f, 9.0f, 2.0f, new CubeDeformation(-0.15f)).texOffs(68, 72).addBox(-9.75f, -4.25f, -0.5f, 9.0f, 2.0f, 2.0f, new CubeDeformation(-0.45f)).texOffs(41, 72).addBox(-9.75f, -6.4f, -0.5f, 9.0f, 2.0f, 2.0f, new CubeDeformation(-0.45f)).texOffs(41, 72).addBox(-9.0f, -6.4f, 4.25f, 8.0f, 2.0f, 2.0f, new CubeDeformation(-0.45f)).texOffs(38, 55).addBox(-9.0f, -6.25f, 4.25f, 2.0f, 9.0f, 2.0f, new CubeDeformation(-0.15f)).texOffs(68, 72).addBox(-9.0f, -4.25f, 4.25f, 8.0f, 2.0f, 2.0f, new CubeDeformation(-0.45f)).texOffs(0, 55).addBox(-3.75f, -6.25f, -0.5f, 2.0f, 9.0f, 2.0f, new CubeDeformation(-0.15f)).texOffs(30, 51).addBox(-3.75f, -7.0f, 4.25f, 2.0f, 9.0f, 2.0f, new CubeDeformation(-0.15f)).texOffs(59, 96).addBox(-3.75f, -6.0f, -1.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)9.0f, (float)22.0f, (float)1.75f));
        PartDefinition hammer2 = partdefinition.addOrReplaceChild("hammer2", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)16.0f, (float)4.0f));
        PartDefinition hammer_lever2 = hammer2.addOrReplaceChild("hammer_lever2", CubeListBuilder.create(), PartPose.offset((float)3.25f, (float)2.5f, (float)0.0f));
        PartDefinition cube_r1 = hammer_lever2.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(58, 51).addBox(-7.0f, -4.0f, -1.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(-0.6f)), PartPose.offsetAndRotation((float)-6.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition hammer_head2 = hammer2.addOrReplaceChild("hammer_head2", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)0.5f, (float)0.0f));
        PartDefinition cube_r2 = hammer_head2.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(65, 92).addBox(-7.0f, -2.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)-5.75f, (float)3.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition cube_r3 = hammer_head2.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(58, 56).addBox(-7.0f, -4.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)-5.75f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition bowl2 = partdefinition.addOrReplaceChild("bowl2", CubeListBuilder.create().texOffs(22, 99).addBox(4.25f, -1.9f, -5.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(-0.1f)).texOffs(19, 86).addBox(4.25f, -0.7f, -5.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(-0.6f)).texOffs(22, 99).addBox(4.25f, -1.9f, -2.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)0.0f, (float)23.0f, (float)7.0f));
        PartDefinition cube_r4 = bowl2.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(20, 100).addBox(6.5f, 1.75f, -1.65f, 4.0f, 1.0f, 3.0f, new CubeDeformation(-0.101f)), PartPose.offsetAndRotation((float)6.25f, (float)-1.4f, (float)-11.5f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition cube_r5 = bowl2.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(22, 99).addBox(-0.5f, -0.5f, -2.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(-0.101f)).texOffs(22, 99).addBox(-0.5f, -0.5f, 1.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(-0.101f)), PartPose.offsetAndRotation((float)6.25f, (float)-1.4f, (float)-4.5f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition spin = partdefinition.addOrReplaceChild("spin", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)18.0f, (float)10.25f));
        PartDefinition axis = spin.addOrReplaceChild("axis", CubeListBuilder.create().texOffs(53, 99).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 11.0f, new CubeDeformation(-0.2f)).texOffs(53, 31).addBox(-3.0f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-6.25f));
        PartDefinition cube_r6 = axis.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(49, 64).addBox(-3.0f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f));
        PartDefinition cube_r7 = axis.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(38, 41).addBox(-3.0f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition cube_r8 = axis.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(77, 63).addBox(-3.0f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f));
        PartDefinition wheel = spin.addOrReplaceChild("wheel", CubeListBuilder.create().texOffs(12, 0).addBox(-1.0f, 1.0378f, -1.3695f, 2.0f, 12.0f, 3.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)0.0f, (float)-0.0378f, (float)-0.1305f));
        PartDefinition cube_r9 = wheel.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(49, 0).addBox(-3.3521f, 5.9475f, -1.1132f, 7.0f, 4.0f, 2.0f, new CubeDeformation(-0.4f)).texOffs(50, 82).addBox(-0.6021f, 6.9975f, -2.1132f, 2.0f, 2.0f, 4.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0436f, (float)-1.9635f));
        PartDefinition cube_r10 = wheel.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(27, 0).addBox(-0.9733f, 0.0267f, -2.1195f, 2.0f, 14.0f, 4.0f, new CubeDeformation(-0.45f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition cube_r11 = wheel.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(18, 45).addBox(-3.3317f, -9.9969f, -1.1123f, 7.0f, 4.0f, 2.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0436f, (float)-2.7489f));
        PartDefinition cube_r12 = wheel.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(0, 45).addBox(-3.3317f, 5.9969f, -1.1123f, 7.0f, 4.0f, 2.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0436f, (float)-0.3927f));
        PartDefinition cube_r13 = wheel.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(44, 31).addBox(-3.6972f, -9.927f, -1.111f, 7.0f, 4.0f, 2.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0436f, (float)-0.3927f));
        PartDefinition cube_r14 = wheel.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(44, 25).addBox(-3.6972f, 5.927f, -1.111f, 7.0f, 4.0f, 2.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0436f, (float)-2.7489f));
        PartDefinition cube_r15 = wheel.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(47, 37).addBox(-3.7177f, -9.9764f, -1.1102f, 7.0f, 4.0f, 2.0f, new CubeDeformation(-0.4f)).texOffs(53, 96).addBox(-1.2369f, -8.9307f, -2.1202f, 2.0f, 2.0f, 4.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0436f, (float)-1.9635f));
        PartDefinition cube_r16 = wheel.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(47, 13).addBox(-3.2823f, -9.9764f, -1.1102f, 7.0f, 4.0f, 2.0f, new CubeDeformation(-0.4f)).texOffs(80, 103).addBox(-0.7631f, -8.9307f, -2.1202f, 2.0f, 2.0f, 4.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0436f, (float)1.9635f));
        PartDefinition cube_r17 = wheel.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(75, 86).addBox(-0.6493f, 6.8835f, -2.1153f, 2.0f, 2.0f, 4.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0436f, (float)-0.3927f));
        PartDefinition cube_r18 = wheel.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(73, 95).addBox(-1.2841f, 7.0446f, -2.1182f, 2.0f, 2.0f, 4.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0436f, (float)-2.7489f));
        PartDefinition cube_r19 = wheel.addOrReplaceChild("cube_r19", CubeListBuilder.create().texOffs(73, 83).addBox(-1.2841f, -9.0446f, -2.1182f, 2.0f, 2.0f, 4.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0436f, (float)-0.3927f));
        PartDefinition cube_r20 = wheel.addOrReplaceChild("cube_r20", CubeListBuilder.create().texOffs(80, 86).addBox(-0.6493f, -8.8835f, -2.1153f, 2.0f, 2.0f, 4.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0436f, (float)-2.7489f));
        PartDefinition cube_r21 = wheel.addOrReplaceChild("cube_r21", CubeListBuilder.create().texOffs(41, 98).addBox(-1.3979f, 6.9975f, -2.1132f, 2.0f, 2.0f, 4.0f, new CubeDeformation(-0.4f)).texOffs(49, 6).addBox(-3.6479f, 5.9475f, -1.1132f, 7.0f, 4.0f, 2.0f, new CubeDeformation(-0.4f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0436f, (float)1.9635f));
        PartDefinition cube_r22 = wheel.addOrReplaceChild("cube_r22", CubeListBuilder.create().texOffs(22, 25).addBox(-0.9733f, -0.0267f, -2.1195f, 2.0f, 14.0f, 4.0f, new CubeDeformation(-0.55f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)2.3562f));
        PartDefinition cube_r23 = wheel.addOrReplaceChild("cube_r23", CubeListBuilder.create().texOffs(0, 25).addBox(-1.0267f, -0.0267f, -2.1195f, 2.0f, 14.0f, 4.0f, new CubeDeformation(-0.35f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.3562f));
        PartDefinition cube_r24 = wheel.addOrReplaceChild("cube_r24", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0267f, 0.0267f, -2.1195f, 2.0f, 14.0f, 4.0f, new CubeDeformation(-0.45f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition cube_r25 = wheel.addOrReplaceChild("cube_r25", CubeListBuilder.create().texOffs(39, 0).addBox(-1.0f, 1.0f, -1.5f, 2.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0378f, (float)0.1305f, (float)0.0f, (float)0.0f, (float)1.5708f));
        PartDefinition cube_r26 = wheel.addOrReplaceChild("cube_r26", CubeListBuilder.create().texOffs(34, 25).addBox(-1.0f, 1.0f, -1.5f, 2.0f, 12.0f, 3.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0378f, (float)0.1305f, (float)0.0f, (float)0.0f, (float)-1.5708f));
        PartDefinition cube_r27 = wheel.addOrReplaceChild("cube_r27", CubeListBuilder.create().texOffs(43, 85).addBox(-3.75f, -4.2878f, -1.1195f, 7.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f));
        PartDefinition cube_r28 = wheel.addOrReplaceChild("cube_r28", CubeListBuilder.create().texOffs(59, 114).addBox(-3.2878f, 2.25f, -1.1195f, 7.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f));
        PartDefinition cube_r29 = wheel.addOrReplaceChild("cube_r29", CubeListBuilder.create().texOffs(43, 81).addBox(-3.7122f, 2.25f, -1.1195f, 7.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f));
        PartDefinition cube_r30 = wheel.addOrReplaceChild("cube_r30", CubeListBuilder.create().texOffs(43, 105).addBox(-3.75f, 2.2122f, -1.1195f, 7.0f, 2.0f, 2.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        PartDefinition cube_r31 = wheel.addOrReplaceChild("cube_r31", CubeListBuilder.create().texOffs(40, 40).addBox(-1.0f, 1.0f, -1.5f, 2.0f, 12.0f, 3.0f, new CubeDeformation(-0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0378f, (float)0.1305f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack p_103111_, VertexConsumer p_103112_, int p_103113_, int p_103114_, int color_overlay) {
        this.root.render(p_103111_, p_103112_, p_103113_, p_103114_, color_overlay);
    }
}

