/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.versionfix;

import doggytalents.common.entity.Dog;
import doggytalents.mixin.ClientLevelMixinAccessor;
import java.util.Optional;
import net.minecraft.DetectedVersion;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTickList;

public class FixClientTeleportDesync_1_21 {
    private static boolean activated = false;

    public static void init() {
        activated = FixClientTeleportDesync_1_21.isTargetMcVersion();
    }

    private static boolean isTargetMcVersion() {
        return Optional.ofNullable(DetectedVersion.BUILT_IN).map(x -> x.getName()).filter(x -> "1.21.1".equals(x)).isPresent();
    }

    public static boolean onDogLerpTo(Dog dog) {
        if (!activated) {
            return false;
        }
        Level level = dog.level();
        if (!(level instanceof ClientLevel)) {
            return false;
        }
        ClientLevel level_client = (ClientLevel)level;
        EntityTickList tickings = ((ClientLevelMixinAccessor)level_client).dtn__getTickingEntities();
        if (tickings == null) {
            return false;
        }
        return !tickings.contains((Entity)dog);
    }
}

