/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import com.google.common.collect.Maps;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.StringEntrySelectScreen;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.CanineTrackerData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Triple;

public class CanineTrackerScreen
extends StringEntrySelectScreen {
    private Player player;
    private final ArrayList<String> dogNameList = new ArrayList();
    private final ArrayList<UUID> dogIdList = new ArrayList();
    private final Map<UUID, Integer> dogDistanceMap = Maps.newHashMap();
    private final Map<UUID, BlockPos> dogPosMap = Maps.newHashMap();
    private boolean showUuid = false;

    public CanineTrackerScreen(Player player) {
        super((Component)Component.translatable((String)"doggytalents.screen.conducting_bone"));
        this.player = player;
    }

    public static void open() {
        Minecraft mc = Minecraft.getInstance();
        CanineTrackerScreen screen = new CanineTrackerScreen((Player)mc.player);
        mc.setScreen((Screen)screen);
        screen.requestDogs();
    }

    @Override
    protected void addUtilitiesButton() {
        int mX = this.width / 2;
        int mY = this.height / 2;
        int pY = mY - 100;
        FlatButton showUuid = new FlatButton(mX - 100 - 60 - 2, pY, 60, 20, (Component)Component.translatable((String)"doggytalents.screen.whistler.heel_by_name.show_uuid"), btn -> {
            btn.setMessage((Component)Component.translatable((String)("doggytalents.screen.whistler.heel_by_name." + (this.showUuid ? "show" : "hide") + "_uuid")));
            this.showUuid = !this.showUuid;
        });
        FlatButton help = new FlatButton(mX - 100 - 20 - 2, pY += showUuid.getHeight() + 2, 20, 20, (Component)Component.literal((String)"?"), b -> {}){

            @Override
            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.renderWidget(graphics, mouseX, mouseY, pTicks);
                if (!this.isHovered) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Component.translatable((String)"doggytalents.screen.radar.help_title").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
                String str = I18n.get((String)"doggytalents.screen.general.entry_select.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, CanineTrackerScreen.this.font));
                graphics.renderComponentTooltip(CanineTrackerScreen.this.font, list, mouseX, mouseY);
            }
        };
        this.addRenderableWidget((GuiEventListener)showUuid);
        this.addRenderableWidget((GuiEventListener)help);
    }

    @Override
    protected void drawEntry(GuiGraphics graphics, int entry_x, int entry_y, int entry_id, boolean is_selected) {
        super.drawEntry(graphics, entry_x, entry_y, entry_id, is_selected);
        int textx1 = this.width / 2 + 100 - 35;
        UUID dogId = this.dogIdList.get(entry_id);
        int dist = this.dogDistanceMap.get(dogId);
        Object text1 = dist > 99999 ? "far" : "" + dist;
        int color = -1;
        if (is_selected) {
            color = this.getHightlightSelectedColor();
        }
        graphics.drawString(this.font, (String)text1, textx1, entry_y, color);
    }

    @Override
    protected void drawNoEntryMsg(GuiGraphics graphics, int x, int y) {
        graphics.drawString(this.font, I18n.get((String)"doggytalents.screen.conducting_bone.no_dog_found", (Object[])new Object[0]), x, y, 16058890);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.mayRenderShowUUID(graphics, mouseX, mouseY, partialTicks);
    }

    private void mayRenderShowUUID(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.showUuid) {
            return;
        }
        Optional<Integer> hover_entry_optional = this.getHoveredEntry(mouseX, mouseY);
        if (!hover_entry_optional.isPresent()) {
            return;
        }
        int entry_id = hover_entry_optional.get();
        UUID uuid = this.dogIdList.get(entry_id);
        MutableComponent uuid_c1 = Component.literal((String)uuid.toString()).withStyle(ChatFormatting.GRAY);
        if (this.height >= 273) {
            int mX = this.width / 2;
            int mY = this.height / 2;
            int uuid_width = this.font.width((FormattedText)uuid_c1);
            int tX = mX - uuid_width / 2;
            int tY = mY + this.getSelectAreaSize() / 2 + 23;
            graphics.drawString(this.font, (Component)uuid_c1, tX, tY, -1);
        } else {
            graphics.renderComponentTooltip(this.font, List.of(uuid_c1), mouseX, mouseY);
        }
    }

    @Override
    protected void onEntrySelected(int id) {
        UUID uuid = this.dogIdList.get(id);
        this.startLocateDog(uuid);
        Minecraft.getInstance().setScreen(null);
    }

    private void requestDogs() {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new CanineTrackerData.RequestDogsData());
    }

    public void assignResponse(List<Triple<UUID, String, BlockPos>> dogLs) {
        this.dogNameList.clear();
        this.dogIdList.clear();
        this.dogDistanceMap.clear();
        this.dogPosMap.clear();
        for (Triple<UUID, String, BlockPos> entry : dogLs) {
            this.dogNameList.add((String)entry.getMiddle());
            this.dogIdList.add((UUID)entry.getLeft());
            BlockPos pos = (BlockPos)entry.getRight();
            int distance = Mth.ceil((float)Mth.sqrt((float)((float)this.player.blockPosition().distSqr((Vec3i)pos))));
            this.dogDistanceMap.put((UUID)entry.getLeft(), distance);
            this.dogPosMap.put((UUID)entry.getLeft(), pos);
        }
        this.updateEntries(this.dogNameList);
    }

    private void startLocateDog(UUID uuid) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new CanineTrackerData.StartLocatingData(uuid));
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }
}

