/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.framework.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class ScrollBar
extends AbstractWidget {
    private int barSize;
    private double barOffset;
    private Direction dir;
    private Screen screen;
    private boolean holdInflate;
    private long inflateAnim = 0L;
    private final long MAX_INFLATE_ANIM = 50L;
    private long prevAnimUpdateMillis = 0L;
    private boolean startedAnimate = false;

    public ScrollBar(int x, int y, int w, int h, Direction dir, int barsize, Screen screen) {
        super(x, y, w, h, (Component)Component.empty());
        this.barSize = dir == Direction.VERTICAL ? Math.min(h, barsize) : Math.min(w, barsize);
        this.dir = dir;
        this.screen = screen;
        this.prevAnimUpdateMillis = System.currentTimeMillis();
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
        long currentTimeMillis;
        long passedAnimMillis;
        if (!this.startedAnimate) {
            this.startedAnimate = true;
            this.prevAnimUpdateMillis = System.currentTimeMillis();
        }
        if ((passedAnimMillis = (currentTimeMillis = System.currentTimeMillis()) - this.prevAnimUpdateMillis) > 0L) {
            this.prevAnimUpdateMillis = currentTimeMillis;
        }
        int barOffset = Mth.floor((double)this.barOffset);
        if (this.holdInflate) {
            this.holdInflate = this.screen.isDragging();
        }
        int BASE_THICK = 3;
        if (passedAnimMillis > 0L) {
            this.inflateAnim = !this.isHovered && !this.holdInflate ? (this.inflateAnim -= passedAnimMillis) : (this.inflateAnim += passedAnimMillis);
        }
        if (this.inflateAnim < 0L) {
            this.inflateAnim = 0L;
        }
        if (this.inflateAnim > 50L) {
            this.inflateAnim = 50L;
        }
        float inflateAnimProgress = (float)this.inflateAnim / 50.0f;
        int maxBarThick = this.dir == Direction.VERTICAL ? this.getWidth() : this.getHeight();
        int barThickAfterAnim = 3 + Mth.ceil((float)(inflateAnimProgress * (float)maxBarThick));
        if (this.dir == Direction.VERTICAL) {
            graphics.fill(this.getX() + this.width - barThickAfterAnim, this.getY(), this.getX() + this.width, this.getY() + this.height, -2026490314);
        } else {
            graphics.fill(this.getX(), this.getY() + this.height - barThickAfterAnim, this.getX() + this.width, this.getY() + this.height, -2026490314);
        }
        if (this.dir == Direction.VERTICAL) {
            graphics.fill(this.getX() + this.getWidth() - barThickAfterAnim, this.getY() + barOffset, this.getX() + this.getWidth(), this.getY() + barOffset + this.barSize, -1);
        } else {
            graphics.fill(this.getX() + barOffset, this.getY() + this.getHeight() - barThickAfterAnim, this.getX() + barOffset + this.barSize, this.getY() + this.getHeight(), -1);
        }
    }

    protected void onDrag(double mouseX, double mouseY, double dY, double dX) {
        double offset;
        this.holdInflate = true;
        if (!this.checkAndHandleMouseOutBound(mouseX, mouseY)) {
            return;
        }
        double d = offset = this.dir == Direction.VERTICAL ? dX : dY;
        if (offset == 0.0) {
            return;
        }
        this.offsetBar(offset);
        this.onValueUpdated();
    }

    private boolean checkAndHandleMouseOutBound(double mouseX, double mouseY) {
        if (mouseX < (double)this.getX()) {
            if (this.barOffset > 0.0) {
                this.setBarOffset(0.0);
                this.onValueUpdated();
            }
            return false;
        }
        if (mouseX > (double)(this.getX() + this.width)) {
            if (this.barOffset < (double)this.getMaxOffsetValue()) {
                this.setBarOffset(this.getMaxOffsetValue());
                this.onValueUpdated();
            }
            return false;
        }
        return true;
    }

    private void offsetBar(double offset) {
        this.barOffset = Mth.clamp((double)(this.barOffset + offset), (double)0.0, (double)this.getMaxOffsetValue());
    }

    public void setBarOffset(double offset) {
        this.barOffset = Mth.clamp((double)offset, (double)0.0, (double)this.getMaxOffsetValue());
    }

    public int getMaxOffsetValue() {
        int ret;
        int n = ret = this.dir == Direction.VERTICAL ? this.height - this.barSize : this.width - this.barSize;
        if (ret < 0) {
            ret = 0;
        }
        return ret;
    }

    public double getProgressValue() {
        int maxOffset = this.getMaxOffsetValue();
        if (maxOffset <= 0) {
            return 0.0;
        }
        return this.barOffset / (double)maxOffset;
    }

    public void onValueUpdated() {
    }

    public void setBarSize(int size) {
        this.barSize = size;
    }

    protected void updateWidgetNarration(NarrationElementOutput p_259858_) {
    }

    public static enum Direction {
        VERTICAL,
        HORIZONTAL;

    }
}

