/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import doggytalents.DoggyItems;
import doggytalents.common.advancements.triggers.DogBandaidApplyTrigger;
import doggytalents.common.advancements.triggers.DogDrunkTrigger;
import doggytalents.common.advancements.triggers.DogRecoveredTrigger;
import doggytalents.common.advancements.triggers.OokamikazeTrigger;
import doggytalents.common.data.DisplayInfoBuilder;
import doggytalents.common.util.DogBedUtil;
import doggytalents.common.util.Util;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.PlayerInteractTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DTAdvancementProvider
extends AdvancementProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public DTAdvancementProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, List.of(new DoggyAdvancementsSubProvider()));
    }

    private static ItemStack createFullRecoveryBed(boolean special) {
        Block casing = special ? Blocks.STRIPPED_CHERRY_LOG : Blocks.STRIPPED_OAK_LOG;
        Block bedding = special ? Blocks.RED_WOOL : Blocks.WHITE_WOOL;
        return DogBedUtil.createItemStackForced(casing, bedding);
    }

    public static class DoggyAdvancementsSubProvider
    implements AdvancementProvider.AdvancementGenerator {
        public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> consumer, ExistingFileHelper existingFileHelper) {
            AdvancementHolder charm_advancement = Advancement.Builder.advancement().display(DisplayInfoBuilder.create().icon(DoggyItems.DOGGY_CHARM).frame(AdvancementType.TASK).translate("doggy_charm_summon").background("adventure.png").build()).addCriterion("summon_dog", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location(), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)DoggyItems.DOGGY_CHARM.get()}))).save(consumer, Util.getResourcePath("dtn_core/summon_dog"));
            AdvancementHolder train_dog_advancement = Advancement.Builder.advancement().parent(charm_advancement).display(DisplayInfoBuilder.create().icon(DoggyItems.TRAINING_TREAT).frame(AdvancementType.TASK).translate("train_dog_hajimemashite").build()).addCriterion("train_dog", PlayerInteractTrigger.TriggerInstance.itemUsedOnEntity((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)DoggyItems.TRAINING_TREAT.get()}), Optional.of(EntityPredicate.wrap((EntityPredicate)EntityPredicate.Builder.entity().of(EntityType.WOLF).build())))).save(consumer, Util.getResourcePath("dtn_core/train_dog"));
            AdvancementHolder sake_advancement = Advancement.Builder.advancement().parent(train_dog_advancement).display(DisplayInfoBuilder.create().icon(DoggyItems.SAKE).frame(AdvancementType.TASK).translate("get_dog_drunk").build()).addCriterion("get_dog_drunk", DogDrunkTrigger.getCriterion()).save(consumer, Util.getResourcePath("default/get_dog_drunk"));
            AdvancementHolder ookamikaze_advancement = Advancement.Builder.advancement().parent(train_dog_advancement).display(DisplayInfoBuilder.create().icon(() -> Items.GUNPOWDER).frame(AdvancementType.TASK).translate("ookamikaze_trigger").build()).addCriterion("ookamikaze_trigger", OokamikazeTrigger.getCriterion()).save(consumer, Util.getResourcePath("default/ookamikaze_trigger"));
            AdvancementHolder bandaid_advancement = Advancement.Builder.advancement().parent(train_dog_advancement).display(DisplayInfoBuilder.create().icon(() -> DoggyItems.BANDAID.get()).frame(AdvancementType.TASK).translate("sterile").build()).addCriterion("give_dog_bandaid", DogBandaidApplyTrigger.getCriterion()).save(consumer, Util.getResourcePath("default/sterile"));
            AdvancementHolder recovered_advancement = Advancement.Builder.advancement().parent(bandaid_advancement).display(DisplayInfoBuilder.create().icon(DTAdvancementProvider.createFullRecoveryBed(false)).frame(AdvancementType.TASK).translate("a_full_recovery").build()).addCriterion("dog_recovered", DogRecoveredTrigger.getCriterion(false)).save(consumer, Util.getResourcePath("default/dog_recovered"));
            AdvancementHolder best_dogtor_advancement = Advancement.Builder.advancement().parent(recovered_advancement).display(DisplayInfoBuilder.create().icon(DTAdvancementProvider.createFullRecoveryBed(true)).frame(AdvancementType.TASK).translate("the_best_dogtor").build()).addCriterion("dog_recovered_special", DogRecoveredTrigger.getCriterion(true)).save(consumer, Util.getResourcePath("default/dog_recovered_special"));
        }
    }
}

