/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.data;

import doggytalents.DoggyBlocks;
import doggytalents.DoggyItems;
import doggytalents.DoggyTags;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class DTItemTagsProvider
extends ItemTagsProvider {
    public DTItemTagsProvider(PackOutput p_275204_, CompletableFuture<HolderLookup.Provider> p_275194_, CompletableFuture<TagsProvider.TagLookup<Block>> p_275634_, @Nullable ExistingFileHelper existingFileHelper) {
        super(p_275204_, p_275194_, p_275634_, "doggytalents", existingFileHelper);
    }

    public String getName() {
        return "DoggyTalents Item Tags";
    }

    public void addTags(HolderLookup.Provider provider) {
        this.createTag(DoggyTags.BEG_ITEMS_TAMED, DoggyItems.THROW_STICK, DoggyItems.THROW_BONE, () -> Items.BONE, DoggyItems.FRISBEE);
        this.appendToTag(DoggyTags.TREATS, new TagKey[0]);
        this.createTag(DoggyTags.BEG_ITEMS_UNTAMED, DoggyItems.TRAINING_TREAT, () -> Items.BONE);
        this.createTag(DoggyTags.BREEDING_ITEMS, DoggyItems.BREEDING_BONE);
        this.createTag(DoggyTags.PACK_PUPPY_BLACKLIST, DoggyItems.THROW_BONE, DoggyItems.THROW_BONE_WET, DoggyItems.THROW_STICK, DoggyItems.THROW_STICK_WET);
        this.createTag(DoggyTags.TREATS, DoggyItems.TRAINING_TREAT, DoggyItems.SUPER_TREAT, DoggyItems.MASTER_TREAT, DoggyItems.KAMI_TREAT);
        this.tag(ItemTags.DYEABLE).add((Object[])new Item[]{DoggyItems.WOOL_COLLAR.get(), DoggyItems.WOOL_COLLAR_THICC.get(), DoggyItems.CAPE_COLOURED.get(), DoggyItems.BOWTIE.get(), DoggyItems.WIG.get(), DoggyItems.FRISBEE.get(), DoggyItems.BAKER_HAT.get(), DoggyItems.CHEF_HAT.get(), DoggyItems.LAB_COAT.get(), DoggyItems.FRISBEE_WET.get(), DoggyItems.FLYING_CAPE.get(), DoggyItems.CERE_GARB.get(), DoggyItems.DOG_PLUSHIE_TOY.get(), DoggyItems.ANGEL_WINGS.get(), DoggyItems.MIDI_KEYBOARD.get(), DoggyBlocks.DOG_BATH.get().asItem()});
    }

    @SafeVarargs
    private final void createTag(TagKey<Item> tag, Supplier<? extends ItemLike> ... items) {
        this.tag(tag).add((Object[])((Item[])Arrays.stream(items).map(Supplier::get).map(ItemLike::asItem).toArray(Item[]::new)));
    }

    @SafeVarargs
    private final void appendToTag(TagKey<Item> tag, TagKey<Item> ... toAppend) {
        this.tag(tag).addTags(toAppend);
    }
}

