/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.DoggyAdvancementTriggers;
import doggytalents.DoggyBlocks;
import doggytalents.DoggyItems;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.feature.DogMode;
import doggytalents.client.screen.DogNewInfoScreen.screen.DogCannotInteractWithScreen;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.DogBounceAction;
import doggytalents.common.entity.ai.triggerable.DogFaintStandAction;
import doggytalents.common.entity.anim.DogPose;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.Util;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

public class DogIncapacitatedMananger {
    private final Dog dog;
    private int recoveryMultiplier = 1;
    private static final ResourceLocation INCAP_MOVEMENT = Util.getResource("injured_slowdown");
    private boolean appliedIncapChanges = false;
    private static final int MAX_BANDAID_COUNT = 8;
    private float partialRecoverVal = 0.0f;
    private int bandagesCount = 0;
    private int bandageCooldown = 0;
    private int drownPoseTick = 0;
    private BlockState atBlockState = null;
    public static final int MAX_INCAP_MSG_LEN = 256;
    private String incapMsg = "";

    public DogIncapacitatedMananger(Dog dog) {
        this.dog = dog;
    }

    public void onModeUpdate(DogMode mode) {
        if (mode != DogMode.INJURED && this.appliedIncapChanges) {
            this.appliedIncapChanges = false;
            this.onExitingIncapMode();
        } else if (mode == DogMode.INJURED && !this.appliedIncapChanges) {
            this.appliedIncapChanges = true;
            this.onEnteringIncapMode();
        }
    }

    private void onEnteringIncapMode() {
        this.recoveryMultiplier = 1;
        this.bandagesCount = 0;
        this.dog.setAttributeModifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, INCAP_MOVEMENT, (d, u) -> new AttributeModifier(u, -0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        this.dog.setDrunkTicks(0);
    }

    private void onExitingIncapMode() {
        this.recoveryMultiplier = 1;
        this.bandagesCount = 0;
        this.dog.removeAttributeModifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, INCAP_MOVEMENT);
        this.incapMsg = "";
    }

    public void tick() {
        if (this.dog.level().isClientSide) {
            this.incapacitatedClientTick();
        } else {
            this.incapacitatedTick();
        }
    }

    public InteractionResult interact(ItemStack stack, Player player, InteractionHand hand) {
        if (this.proccessBandage(stack, player).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        Item item = stack.getItem();
        if (item == Items.TOTEM_OF_UNDYING) {
            this.useTotem(stack, player);
            return InteractionResult.SUCCESS;
        }
        if (this.handleOwnerRide(stack, player).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        if (this.proccessSitStandOrder(player).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        if (this.dog.level().isClientSide && player == this.dog.getOwner()) {
            DogCannotInteractWithScreen.open(this.dog);
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult proccessBandage(ItemStack stack, Player player) {
        boolean isBandage;
        boolean wagyu = this.needWagyu();
        boolean bl = isBandage = wagyu && stack.getItem() == DoggyItems.GOLDEN_A_FIVE_WAGYU.get() || !wagyu && stack.getItem() == DoggyItems.BANDAID.get();
        if (isBandage) {
            this.useBandage(stack, player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void useBandage(ItemStack stack, Player player) {
        if (this.dog.level().isClientSide) {
            return;
        }
        if ((float)this.bandageCooldown > 0.0f) {
            return;
        }
        if (this.bandagesCount >= 8) {
            return;
        }
        this.bandageCooldown = 10;
        player.getCooldowns().addCooldown(stack.getItem(), 11);
        ++this.bandagesCount;
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        if (this.bandagesCount >= 8) {
            this.dog.triggerAnimationAction(new DogFaintStandAction(this.dog, this.getFaintStandAnim()));
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sP = (ServerPlayer)player;
            DoggyAdvancementTriggers.DOG_BANDAID_APPLY_TRIGGER.trigger(this.dog, sP);
        }
    }

    private void useTotem(ItemStack stack, Player player) {
        if (this.dog.level().isClientSide) {
            return;
        }
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        List<Dog> defeatedDogs = DogUtil.getOtherIncapacitatedDogNearby(this.dog);
        for (Dog d : defeatedDogs) {
            d.setDogIncapValue(0);
            d.incapacitatedMananger.incapacitatedExit();
            d.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
            d.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
            d.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
        }
        this.dog.level().broadcastEntityEvent((Entity)this.dog, (byte)35);
    }

    private InteractionResult handleOwnerRide(ItemStack stack, Player player) {
        if (player.hasPassenger((Entity)this.dog)) {
            if (!this.dog.level().isClientSide) {
                this.dog.unRide();
            }
            return InteractionResult.SUCCESS;
        }
        Item item = stack.getItem();
        if (item != Items.BONE) {
            return InteractionResult.PASS;
        }
        if (this.dog.isVehicle()) {
            return InteractionResult.PASS;
        }
        if (this.dog.getOwner() != player) {
            return InteractionResult.PASS;
        }
        if (!this.dog.level().isClientSide && this.dog.startRiding((Entity)player)) {
            player.displayClientMessage((Component)Component.translatable((String)"talent.doggytalents.bed_finder.dog_mount", (Object[])new Object[]{this.dog.getGenderPronoun()}), true);
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult proccessSitStandOrder(Player player) {
        if (!this.canMove()) {
            return InteractionResult.PASS;
        }
        UUID owner_uuid = this.dog.getOwnerUUID();
        if (owner_uuid == null) {
            return InteractionResult.PASS;
        }
        if (!owner_uuid.equals(player.getUUID())) {
            return InteractionResult.PASS;
        }
        this.dog.setOrderedToSit(!this.dog.isOrderedToSit());
        this.dog.getNavigation().stop();
        return InteractionResult.SUCCESS;
    }

    public void onHurt() {
        if (((Boolean)ConfigHandler.SERVER.INCAP_VAL_RESET_WHEN_HURT.get()).booleanValue()) {
            this.dropBandages();
            int currentIncapVal = this.dog.getDogIncapValue();
            if (currentIncapVal < this.dog.getDefaultInitIncapVal()) {
                this.dog.setDogIncapValue(this.dog.getDefaultInitIncapVal());
            }
        }
    }

    private void dropBandages() {
        if (this.needWagyu()) {
            return;
        }
        float keep_precentage = 0.8f - (float)this.dog.getRandom().nextInt(4) * 0.1f;
        int keep_amount = Mth.floor((float)(keep_precentage * (float)this.bandagesCount));
        for (int i = 0; i < keep_amount; ++i) {
            Containers.dropItemStack((Level)this.dog.level(), (double)this.dog.getX(), (double)this.dog.getY(), (double)this.dog.getZ(), (ItemStack)new ItemStack((ItemLike)DoggyItems.BANDAID.get(), 1));
        }
        this.bandageCooldown = 200;
        this.bandagesCount = 0;
        IncapacitatedSyncState incap_state = this.dog.getIncapSyncState();
        IncapacitatedSyncState new_incap_state = incap_state.updateBandaid(this.bandagesCount);
        if (new_incap_state != incap_state) {
            this.dog.setIncapSyncState(new_incap_state);
        }
    }

    private void displayToastIncapacitated(Player player) {
        player.displayClientMessage((Component)Component.translatable((String)"doggui.invalid_dog.incapacitated.title").withStyle(ChatFormatting.RED), true);
    }

    public void incapacitatedClientTick() {
        this.drownPoseTick = this.isDogDeepInFluid() ? ++this.drownPoseTick : 0;
        if (this.dog.isDogVariantRenderEffective() && this.dog.dogVariant().customInjuredTexture().isPresent()) {
            return;
        }
        IncapacitatedSyncState sync_state = this.dog.getIncapSyncState();
        DefeatedType type = sync_state.type;
        switch (type.ordinal()) {
            case 2: {
                if (this.dog.getDogIncapValue() < this.dog.getDefaultInitIncapVal() - 10) break;
                for (int i = 0; i < 2; ++i) {
                    float f1 = (this.dog.getRandom().nextFloat() * 2.0f - 1.0f) * this.dog.getBbWidth() * 0.8f;
                    float f2 = (this.dog.getRandom().nextFloat() * 2.0f - 1.0f) * this.dog.getBbWidth() * 0.8f;
                    this.dog.level().addParticle((ParticleOptions)ParticleTypes.ASH, this.dog.getX() + (double)f1, this.dog.getY() + 0.4, this.dog.getZ() + (double)f2, 0.0, -0.05, 0.0);
                }
                if (this.dog.getRandom().nextInt(3) != 0) break;
                float f1 = (this.dog.getRandom().nextFloat() * 2.0f - 1.0f) * this.dog.getBbWidth() * 0.5f;
                float f2 = (this.dog.getRandom().nextFloat() * 2.0f - 1.0f) * this.dog.getBbWidth() * 0.5f;
                this.dog.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.dog.getX() + (double)f1, this.dog.getY() + (double)this.dog.getEyeHeight(), this.dog.getZ() + (double)f2, 0.0, 0.05, 0.0);
                break;
            }
            case 1: {
                if (this.dog.getDogIncapValue() < this.dog.getDefaultInitIncapVal() - 10 || this.dog.tickCount % 8 != 0) break;
                for (int i = 0; i < 2; ++i) {
                    float f1 = (this.dog.getRandom().nextFloat() * 2.0f - 1.0f) * this.dog.getBbWidth() * 0.8f;
                    float f2 = (this.dog.getRandom().nextFloat() * 2.0f - 1.0f) * this.dog.getBbWidth() * 0.8f;
                    this.dog.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.NETHER_WART)), this.dog.getX() + (double)f1, this.dog.getY() + 0.4, this.dog.getZ() + (double)f2, 0.0, -0.05, 0.0);
                }
                break;
            }
            case 4: {
                if (this.dog.getDogIncapValue() < this.dog.getDefaultInitIncapVal() - 10 || this.dog.tickCount % 8 != 0) break;
                for (int i = 0; i < 2; ++i) {
                    float f1 = (this.dog.getRandom().nextFloat() * 2.0f - 1.0f) * this.dog.getBbWidth() * 0.8f;
                    float f2 = (this.dog.getRandom().nextFloat() * 2.0f - 1.0f) * this.dog.getBbWidth() * 0.8f;
                    this.dog.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.dog.getX() + (double)f1, this.dog.getY() + 0.4, this.dog.getZ() + (double)f2, 0.0, -0.05, 0.0);
                }
                break;
            }
        }
    }

    public void incapacitatedTick() {
        IncapacitatedSyncState incap_state;
        IncapacitatedSyncState new_incap_state;
        if (this.dog.getDogIncapValue() <= 0) {
            this.incapacitatedExit();
            return;
        }
        if (this.partialRecoverVal >= 1.0f) {
            this.dog.setDogIncapValue(this.dog.getDogIncapValue() - 1);
            this.partialRecoverVal = 0.0f;
        }
        if (this.bandageCooldown > 0) {
            --this.bandageCooldown;
        }
        if ((new_incap_state = (incap_state = this.dog.getIncapSyncState()).updateBandaid(this.bandagesCount)) != incap_state) {
            this.dog.setIncapSyncState(new_incap_state);
        }
        if (!((Boolean)ConfigHandler.SERVER.INCAP_VAL_RESET_WHEN_HURT.get()).booleanValue() && this.bandagesCount > 0 && this.isConditionDestroyBandages(this.dog)) {
            this.dropBandages();
            return;
        }
        this.healWithBandaid(new_incap_state.bandaid);
        LivingEntity owner = this.dog.getOwner();
        BlockState dog_b0_state = this.dog.level().getBlockState(this.dog.blockPosition());
        Block dog_b0_block = dog_b0_state.getBlock();
        if (dog_b0_block == Blocks.AIR) {
            this.partialRecoverVal += 0.001f * (float)this.recoveryMultiplier;
        } else if (dog_b0_block == DoggyBlocks.DOG_BED.get() || dog_b0_state.is(BlockTags.BEDS)) {
            this.incapacitatedHealWithBed(owner);
        }
    }

    private boolean isConditionDestroyBandages(Dog dog) {
        if (!dog.fireImmune() && dog.isOnFire()) {
            return true;
        }
        if (!dog.canSwimUnderwater() && dog.isInWater()) {
            return true;
        }
        return !dog.dogFallImmune() && dog.fallDistance > 3.0f;
    }

    private void incapacitatedExit() {
        int bandaid_count0 = this.bandagesCount;
        this.dog.maxHealth();
        this.dog.setMode(DogMode.DOCILE);
        this.dog.setDogHunger(this.dog.getMaxHunger());
        this.dog.setDogIncapValue(0);
        this.dog.setOrderedToSit(true);
        this.dog.setIncapSyncState(IncapacitatedSyncState.NONE);
        this.dog.triggerAnimationAction(new DogBounceAction(this.dog));
        this.dog.removeAllEffects();
        Level level = this.dog.level();
        if (level instanceof ServerLevel) {
            ServerLevel sL = (ServerLevel)level;
            sL.sendParticles((ParticleOptions)ParticleTypes.HEART, this.dog.getX(), this.dog.getY(), this.dog.getZ(), 24, (double)this.dog.getBbWidth(), (double)0.8f, (double)this.dog.getBbWidth(), 0.1);
        }
        if (bandaid_count0 > 0) {
            LivingEntity owner = this.dog.getOwner();
            this.triggerAdvancement(owner, bandaid_count0);
        }
    }

    private void triggerAdvancement(LivingEntity player, int bandages_count0) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sP = (ServerPlayer)player;
        DoggyAdvancementTriggers.DOG_RECOVERED_TRIGGER.trigger(this.dog, sP, false);
        if (this.isBestRecoveryCondition(bandages_count0)) {
            DoggyAdvancementTriggers.DOG_RECOVERED_TRIGGER.trigger(this.dog, sP, true);
        }
    }

    private boolean isBestRecoveryCondition(int bandaid_count0) {
        if (bandaid_count0 < 8) {
            return false;
        }
        BlockState dog_b0_state = this.dog.level().getBlockState(this.dog.blockPosition());
        Block dog_b0_block = dog_b0_state.getBlock();
        boolean is_laying_bed = dog_b0_block == DoggyBlocks.DOG_BED.get() || dog_b0_state.is(BlockTags.BEDS);
        return is_laying_bed;
    }

    private void incapacitatedHealWithBed(LivingEntity owner) {
        this.partialRecoverVal += 0.002f * (float)this.recoveryMultiplier;
        if (owner == null) {
            return;
        }
        if (this.dog.distanceToSqr((Entity)owner) > 100.0) {
            return;
        }
        this.partialRecoverVal += 0.02f * (float)this.recoveryMultiplier;
        if (!(this.dog.level() instanceof ServerLevel)) {
            return;
        }
        if (this.dog.tickCount % 10 != 0) {
            return;
        }
        ((ServerLevel)this.dog.level()).sendParticles((ParticleOptions)ParticleTypes.HEART, this.dog.getX(), this.dog.getY(), this.dog.getZ(), 1, (double)this.dog.getBbWidth(), (double)0.8f, (double)this.dog.getBbWidth(), 0.1);
    }

    private void healWithBandaid(BandaidState state) {
        switch (state.ordinal()) {
            case 2: {
                this.partialRecoverVal += 0.02f * (float)this.recoveryMultiplier;
                break;
            }
            case 1: {
                this.partialRecoverVal += 0.01f * (float)this.recoveryMultiplier;
                break;
            }
        }
    }

    public boolean canMove() {
        return this.dog.getIncapSyncState().bandaid == BandaidState.FULL;
    }

    public boolean shouldApplyCustomPushBehaviour(Entity target) {
        Dog other_dog;
        boolean only_normal_when = target instanceof Dog && (other_dog = (Dog)target).isDefeated();
        return !only_normal_when;
    }

    public void save(CompoundTag tag) {
        CompoundTag tg0 = new CompoundTag();
        IncapacitatedSyncState syncState = this.dog.getIncapSyncState();
        tg0.putInt("type", syncState.type.getId());
        tg0.putInt("bandaid", this.bandagesCount);
        tg0.putInt("poseid", syncState.poseId);
        tg0.putString("incapMsg", this.incapMsg);
        tag.put("doggyIncapacitated", (Tag)tg0);
    }

    public void load(CompoundTag tag) {
        CompoundTag tg0 = tag.getCompound("doggyIncapacitated");
        DefeatedType type = DefeatedType.byId(tg0.getInt("type"));
        int bandaid_count = tg0.getInt("bandaid");
        int poseId = tg0.getInt("poseid");
        this.incapMsg = tg0.getString("incapMsg");
        this.bandagesCount = bandaid_count;
        this.dog.setIncapSyncState(new IncapacitatedSyncState(type, BandaidState.getState(bandaid_count), poseId));
    }

    public DogPose getPose() {
        int id = this.dog.getIncapSyncState().poseId;
        if (this.showDrownPose()) {
            return DogPose.DROWN;
        }
        switch (id) {
            default: {
                return DogPose.FAINTED;
            }
            case 1: 
        }
        return DogPose.FAINTED_2;
    }

    public DogAnimation getAnim() {
        int id = this.dog.getIncapSyncState().poseId;
        if (this.showDrownPose()) {
            return DogAnimation.DROWN;
        }
        switch (id) {
            default: {
                return DogAnimation.FAINT;
            }
            case 1: 
        }
        return DogAnimation.FAINT_2;
    }

    private boolean isDogDeepInFluid() {
        FluidType type = this.dog.getMaxHeightFluidType();
        if (type.isAir()) {
            return false;
        }
        if (type == NeoForgeMod.LAVA_TYPE.value() && this.dog.fireImmune()) {
            return false;
        }
        double height = this.dog.getFluidTypeHeight(type);
        return height > 0.5;
    }

    private boolean showDrownPose() {
        return this.drownPoseTick > 20;
    }

    public DogAnimation getFaintStandAnim() {
        int id = this.dog.getIncapSyncState().poseId;
        if (this.dog.isInWater() || this.dog.isInLava()) {
            return DogAnimation.NONE;
        }
        switch (id) {
            default: {
                return DogAnimation.FAINT_STAND_1;
            }
            case 1: 
        }
        return DogAnimation.FAINT_STAND_2;
    }

    public void setIncapMsg(String s) {
        if (s == null) {
            return;
        }
        if (((String)s).isEmpty()) {
            return;
        }
        if (((String)s).length() > 256) {
            s = ((String)s).substring(0, 250) + "..";
        }
        this.incapMsg = s;
    }

    public String getIncapMsg() {
        return this.incapMsg;
    }

    private boolean needWagyu() {
        return this.dog.getIncapSyncState().type == DefeatedType.STARVE;
    }

    public static class IncapacitatedSyncState {
        public static IncapacitatedSyncState NONE = new IncapacitatedSyncState(DefeatedType.NONE);
        public DefeatedType type = DefeatedType.NONE;
        public BandaidState bandaid = BandaidState.NONE;
        public int poseId = 0;

        public IncapacitatedSyncState(DefeatedType type) {
            this.type = type;
        }

        public IncapacitatedSyncState(DefeatedType type, BandaidState bandaid) {
            this.type = type;
            this.bandaid = bandaid;
        }

        public IncapacitatedSyncState(DefeatedType type, BandaidState bandaid, int poseId) {
            this.type = type;
            this.bandaid = bandaid;
            this.poseId = poseId;
        }

        public IncapacitatedSyncState copy() {
            return new IncapacitatedSyncState(this.type, this.bandaid, this.poseId);
        }

        public IncapacitatedSyncState updateBandaid(int bandaid_count) {
            BandaidState new_state = BandaidState.getState(bandaid_count);
            if (new_state == this.bandaid) {
                return this;
            }
            return new IncapacitatedSyncState(this.type, new_state, this.poseId);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IncapacitatedSyncState)) {
                return false;
            }
            IncapacitatedSyncState state = (IncapacitatedSyncState)obj;
            if (this.type != state.type) {
                return false;
            }
            if (this.bandaid != state.bandaid) {
                return false;
            }
            return this.poseId == state.poseId;
        }
    }

    public static enum DefeatedType {
        NONE(0),
        BLOOD(1),
        BURN(2),
        POISON(3),
        DROWN(4),
        STARVE(5);

        private final int id;

        private DefeatedType(int id) {
            this.id = id;
        }

        public static DefeatedType byId(int i) {
            DefeatedType[] values = DefeatedType.values();
            if (i < 0) {
                return NONE;
            }
            if (i >= values.length) {
                return NONE;
            }
            return values[i];
        }

        public int getId() {
            return this.id;
        }
    }

    public static enum BandaidState {
        NONE(0),
        HALF(1),
        FULL(2);

        private final int id;

        private BandaidState(int id) {
            this.id = id;
        }

        public static BandaidState byId(int i) {
            BandaidState[] values = BandaidState.values();
            if (i < 0) {
                return NONE;
            }
            if (i >= values.length) {
                return NONE;
            }
            return values[i];
        }

        public static BandaidState getState(int bandaid_count) {
            if (bandaid_count <= 3) {
                return NONE;
            }
            if (bandaid_count <= 7) {
                return HALF;
            }
            return FULL;
        }

        public int getId() {
            return this.id;
        }
    }
}

