/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.DogGreetOwnerAction;
import doggytalents.common.storage.DogLocationStorage;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class DogOwnerDistanceManager {
    private static final int OWNER_FAR_AWAY_DISTANCE_SQR = 400;
    private static final int OWNER_START_GREET_DISTANCE_SQR = 144;
    private static final long START_MISSING_OWNER_TIME = 96000L;
    private static final int UPDATE_INTERVAL = 5;
    private final Dog dog;
    private long lastWithOwnerTime;
    private boolean willGreet;
    private int tickTillUpdate;
    private long lastOwnerLeftInteval;

    public DogOwnerDistanceManager(Dog dog) {
        this.dog = dog;
        this.lastWithOwnerTime = dog.level().getDayTime();
    }

    public void tick() {
        if (--this.tickTillUpdate <= 0) {
            this.tickTillUpdate = 5;
            LivingEntity owner = this.dog.getOwner();
            if (owner != null) {
                this.updateGreetingCondition(this.dog, owner);
            }
        }
    }

    private void updateGreetingCondition(Dog dog, @Nonnull LivingEntity owner) {
        if (this.isOwnerReturned(dog, owner)) {
            long gtime = dog.level().getDayTime();
            long dtime = gtime - this.lastWithOwnerTime;
            if (dtime >= 96000L) {
                this.willGreet = true;
                this.lastOwnerLeftInteval = dtime;
            }
            this.lastWithOwnerTime = gtime;
        }
        if (this.canStartGreeting(dog, owner)) {
            this.triggerGreetingAction(dog, owner, this.lastOwnerLeftInteval);
            this.lastOwnerLeftInteval = 0L;
        }
    }

    private boolean isOwnerReturned(Dog dog, LivingEntity owner) {
        return dog.distanceToSqr((Entity)owner) < 400.0;
    }

    private boolean canStartGreeting(Dog dog, LivingEntity owner) {
        return this.willGreet && dog.distanceToSqr((Entity)owner) <= 144.0 && !owner.isSpectator() && !dog.isBusy();
    }

    public void save(CompoundTag tag) {
        CompoundTag tg0 = new CompoundTag();
        tg0.putLong("lastWithOwnerTime", this.lastWithOwnerTime);
        tg0.putBoolean("willGreet", this.willGreet);
        tag.put("ownerDistanceManager", (Tag)tg0);
    }

    public void load(CompoundTag tag) {
        if (tag.contains("ownerDistanceManager", 10)) {
            CompoundTag tg0 = tag.getCompound("ownerDistanceManager");
            this.lastWithOwnerTime = tg0.getLong("lastWithOwnerTime");
            this.willGreet = tg0.getBoolean("willGreet");
        } else {
            this.lastWithOwnerTime = this.dog.level().getDayTime();
            this.willGreet = false;
        }
    }

    public void triggerGreetingAction(Dog dog, @Nonnull LivingEntity owner, long ownerLeftInterval) {
        this.willGreet = false;
        boolean greetOwnerEnabled = (Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DOG_GREET_OWNER);
        int greetOwnerLimit = (Integer)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DOG_GREET_OWNER_LIMIT);
        if (!greetOwnerEnabled) {
            return;
        }
        if (greetOwnerLimit > 0 && DogOwnerDistanceManager.getGreetCountForOwner(owner) >= greetOwnerLimit) {
            return;
        }
        if (dog.triggerAction(new DogGreetOwnerAction(dog, owner, ownerLeftInterval))) {
            DogOwnerDistanceManager.incGreetCountForOwner(owner);
        }
    }

    public void onGreetingActionStop(LivingEntity owner) {
        DogOwnerDistanceManager.decGreetCountForOwner(owner);
    }

    public static int getGreetCountForOwner(LivingEntity owner) {
        DogLocationStorage storage = DogLocationStorage.get(owner.getServer());
        return storage.grettingDogLimitMap.getOrDefault(owner.getUUID(), 0);
    }

    public static void incGreetCountForOwner(LivingEntity owner) {
        DogLocationStorage storage = DogLocationStorage.get(owner.getServer());
        storage.grettingDogLimitMap.compute(owner.getUUID(), (uuid, old_val) -> {
            if (old_val == null) {
                return 1;
            }
            return old_val + 1;
        });
    }

    public static void decGreetCountForOwner(LivingEntity owner) {
        DogLocationStorage storage = DogLocationStorage.get(owner.getServer());
        storage.grettingDogLimitMap.computeIfPresent(owner.getUUID(), (uuid, old_val) -> {
            if (old_val == null) {
                return null;
            }
            int new_val = old_val - 1;
            if (new_val <= 0) {
                return null;
            }
            return new_val;
        });
    }
}

