/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.feature.DogMode;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;

public class BerserkerModeGoal
extends NearestAttackableTargetGoal<Mob> {
    private final Dog dog;

    public BerserkerModeGoal(Dog dog) {
        super((Mob)dog, Mob.class, false, e -> {
            if (BerserkerModeGoal.targetingOwnerCheck(dog, e)) {
                return true;
            }
            return e instanceof Enemy;
        });
        this.dog = dog;
    }

    private static boolean targetingOwnerCheck(Dog dog, LivingEntity e) {
        if (!((Boolean)ConfigHandler.SERVER.BG_MODE_LESS_STRICT.get()).booleanValue()) {
            return false;
        }
        if (!(e instanceof Mob)) {
            return false;
        }
        Mob mob = (Mob)e;
        LivingEntity owner = dog.getOwner();
        return mob.getTarget() == owner;
    }

    public boolean canUse() {
        return this.dog.isMode(DogMode.BERSERKER, DogMode.BERSERKER_MINOR, DogMode.PATROL) && super.canUse();
    }
}

