/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class DogAvoidPushWhenIdleGoal
extends Goal {
    private Dog dog;
    private int cooldown = 0;
    private int grace = 0;

    public DogAvoidPushWhenIdleGoal(Dog dog) {
        this.dog = dog;
    }

    public boolean canUse() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        if (!this.dog.canDogResistPush()) {
            return false;
        }
        return this.checkIfShouldBeginResisting();
    }

    public boolean canContinueToUse() {
        if (!this.dog.canDogResistPush()) {
            return false;
        }
        return this.grace > 0;
    }

    public void start() {
        this.grace = 3;
        this.dog.setDogResistingPush(true);
    }

    public void tick() {
        if (this.grace > 0) {
            --this.grace;
        }
    }

    public void stop() {
        this.grace = 0;
        this.dog.setDogResistingPush(false);
    }

    private boolean checkIfShouldBeginResisting() {
        boolean currently_damaging;
        Vec3 delta = this.dog.getDeltaMovement();
        double delta_l = delta.x * delta.x + delta.z * delta.z;
        double xz_cap = this.dog.getDogPushResistXZCap();
        if (delta_l <= xz_cap * xz_cap) {
            return false;
        }
        Vec3 dog_pos = this.dog.position();
        Vec3 dog_pos_1 = new Vec3(dog_pos.x + delta.x, dog_pos.y, dog_pos.z + delta.z);
        BlockPos dog_b0 = BlockPos.containing((Position)dog_pos);
        BlockPos dog_b1 = BlockPos.containing((Position)dog_pos_1);
        PathType blockType = this.dog.getBlockPathTypeViaAlterations(dog_b0);
        boolean bl = currently_damaging = DogUtil.isDangerPathType(blockType) && this.dog.getPathfindingMalus(blockType) < 0.0f;
        if (currently_damaging) {
            this.cooldown = 10;
            return false;
        }
        if (!dog_b0.equals((Object)dog_b1)) {
            blockType = this.dog.getBlockPathTypeViaAlterations(dog_b1);
        }
        if (DogUtil.isDangerPathType(blockType)) {
            return true;
        }
        if (blockType != PathType.OPEN) {
            return false;
        }
        boolean noWalkable = true;
        for (int i = 1; i <= this.dog.getMaxFallDistance(); ++i) {
            PathType type = this.dog.getBlockPathTypeViaAlterations(dog_b1.below(i));
            if (type == PathType.OPEN) continue;
            noWalkable = type != PathType.WALKABLE;
            break;
        }
        return noWalkable;
    }
}

