/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;

public class DogDrunkGoal
extends Goal {
    private Dog dog;
    private int extendedGoalTick;

    public DogDrunkGoal(Dog dog) {
        this.dog = dog;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.dog.isDoingFine()) {
            return false;
        }
        return this.dog.isDogDrunk();
    }

    public boolean canContinueToUse() {
        if (!this.dog.isDoingFine()) {
            return false;
        }
        return this.extendedGoalTick > 0;
    }

    public void start() {
        this.dog.setAnim(DogAnimation.DRUNK_START);
        this.dog.setInDrunkPose(true);
        this.extendedGoalTick = DogAnimation.STAND_QUICK.getLengthTicks();
        this.dog.getNavigation().stop();
    }

    public void tick() {
        if (this.dog.getAnim() == DogAnimation.NONE) {
            this.dog.setAnim(DogAnimation.DRUNK_LOOP);
        }
        if (!this.dog.isDogDrunk()) {
            this.dog.setInDrunkPose(false);
            if (this.dog.getAnim() == DogAnimation.DRUNK_LOOP) {
                this.dog.setAnim(DogAnimation.STAND_QUICK);
            }
            --this.extendedGoalTick;
        }
    }

    public void stop() {
        this.dog.setInDrunkPose(false);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

