/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class DogFollowOwnerGoalDefeated
extends Goal {
    private Dog dog;
    private int tickTillPathRecalc;
    private int tickTillWhine = 20;
    private LivingEntity owner;

    public DogFollowOwnerGoalDefeated(Dog dog) {
        this.dog = dog;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity owner;
        if (!this.dog.isDefeated()) {
            return false;
        }
        if (this.dog.isOrderedToSit()) {
            return false;
        }
        if (this.tickTillWhine > 0) {
            --this.tickTillWhine;
        }
        if ((owner = this.dog.getOwner()) == null) {
            return false;
        }
        if (owner.isSpectator()) {
            return false;
        }
        double distance_sqr = owner.distanceToSqr((Entity)this.dog);
        if (distance_sqr < 100.0 || distance_sqr > 256.0) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean canContinueToUse() {
        LivingEntity owner;
        if (!this.dog.isDefeated()) {
            return false;
        }
        if (this.dog.isOrderedToSit()) {
            return false;
        }
        if (this.dog.getNavigation().isDone()) {
            return false;
        }
        if (this.tickTillWhine > 0) {
            --this.tickTillWhine;
        }
        if ((owner = this.dog.getOwner()) == null) {
            return false;
        }
        if (owner.isSpectator()) {
            return false;
        }
        double distance_sqr = owner.distanceToSqr((Entity)this.dog);
        return !(distance_sqr < 4.0) && !(distance_sqr > 256.0);
    }

    public void tick() {
        if (this.owner == null) {
            return;
        }
        this.dog.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.dog.getMaxHeadXRot());
        if (--this.tickTillPathRecalc > 0) {
            return;
        }
        this.tickTillPathRecalc = 15;
        this.dog.getNavigation().moveTo((Entity)this.owner, 1.0);
    }

    public void stop() {
        if (this.dog.distanceToSqr((Entity)this.owner) > 256.0) {
            this.tickTillWhine = 20;
        }
        this.owner = null;
    }
}

