/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import net.minecraft.sounds.SoundEvents;

public class DogHowlAction
extends TriggerableAction {
    private int stopTick;
    private int tickTillHowl = 50;

    public DogHowlAction(Dog dog) {
        super(dog, false, false);
    }

    @Override
    public void onStart() {
        this.stopTick = this.dog.tickCount + DogAnimation.HOWL.getLengthTicks();
        this.dog.setAnim(DogAnimation.HOWL);
        this.dog.dogSoundManager.setAmbientLocked(true);
    }

    @Override
    public void tick() {
        if (this.dog.getAnim() != DogAnimation.HOWL) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (this.dog.tickCount >= this.stopTick) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        --this.tickTillHowl;
        if (this.tickTillHowl == 0) {
            this.dog.dogSoundManager.playInterruptible(SoundEvents.WOLF_HOWL, 1.0f, this.dog.getVoicePitch());
        } else if (this.tickTillHowl == 30) {
            this.dog.playSound(SoundEvents.WOLF_GROWL, 0.3f, this.dog.getVoicePitch());
        }
    }

    @Override
    public void onStop() {
        if (this.dog.getAnim() == DogAnimation.HOWL) {
            this.dog.setAnim(DogAnimation.NONE);
        }
        if (this.isStarted()) {
            this.dog.dogSoundManager.setAmbientLocked(false);
            this.dog.dogSoundManager.interuptPlaying();
        }
    }

    @Override
    public boolean canOverrideSit() {
        return true;
    }
}

