/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;

public class DogPlayTagAction
extends TriggerableAction {
    private boolean ownerBeenTagged = false;
    private static final int RUN_AWAY_RADIUS = 20;
    private static final int RUN_AWAY_RADIUS_MIN = 16;
    private static final int RUN_AWAY_PATH_INTERVAL = 10;
    private static final int RUN_AWAY_LOOKBACK_INTERVAL = 20;
    private static final int RUN_AWAY_LOOKBACK_TIME = 20;
    private static final int TIME_LIMIT_PER_TURN = 400;
    private int tickTillPathRecalc;
    private int cooldownChase;
    private int timeLeft;
    private int tickTillLook;
    private LivingEntity owner;

    public DogPlayTagAction(Dog dog, LivingEntity owner) {
        super(dog, true, true);
        this.owner = owner;
    }

    @Override
    public void onStart() {
        this.timeLeft = 400;
        this.cooldownChase = 10;
    }

    @Override
    public void tick() {
        if (!this.owner.isAlive() || this.owner.isSpectator()) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        --this.timeLeft;
        if (this.dog.distanceToSqr((Entity)this.owner) > 400.0 || this.timeLeft <= 0) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            if (this.ownerBeenTagged) {
                this.owner.sendSystemMessage((Component)Component.translatable((String)"dog.msg.play_tag.dog_win", (Object[])new Object[]{this.dog.getName().getString()}));
                this.dog.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 1));
            } else {
                this.owner.sendSystemMessage((Component)Component.translatable((String)"dog.msg.play_tag.you_win", (Object[])new Object[]{this.dog.getName().getString()}));
                this.owner.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 1));
            }
            return;
        }
        if (!this.ownerBeenTagged) {
            if (this.cooldownChase <= 0) {
                this.chaseOwner(this.dog, this.owner);
            } else {
                --this.cooldownChase;
            }
        } else {
            this.runAway(this.dog, this.owner);
        }
    }

    private void chaseOwner(Dog dog, LivingEntity owner) {
        PathNavigation n = dog.getNavigation();
        BlockPos dog_b0 = dog.blockPosition();
        BlockPos owner_b0 = owner.blockPosition();
        double d0 = dog.distanceToSqr((Entity)owner);
        this.dog.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.dog.getMaxHeadXRot());
        if (--this.tickTillPathRecalc <= 0) {
            this.tickTillPathRecalc = 10;
            if (d0 > 256.0) {
                this.tickTillPathRecalc += 5;
            }
            n.moveTo((Entity)owner, 1.0);
        }
        if (n.isDone() && dog_b0.distSqr((Vec3i)owner_b0) <= 4.0 && !this.canReachTarget(owner, d0)) {
            dog.getMoveControl().setWantedPosition(owner.getX(), owner.getY(), owner.getZ(), 1.0);
        }
        if (n.isDone() && dog.tickCount % 2 != 0 && !this.canReachTarget(owner, d0)) {
            this.tickTillPathRecalc = 0;
        }
        if (this.checkAndTag(dog, owner)) {
            n.stop();
            owner.sendSystemMessage((Component)Component.translatable((String)"dog.msg.play_tag.gotcha", (Object[])new Object[]{dog.getName().getString()}));
            this.dog.playSound(SoundEvents.WOLF_AMBIENT, 1.0f, 1.0f);
            this.ownerBeenTagged = true;
            this.cooldownChase = 30;
            this.timeLeft = 400;
            return;
        }
    }

    private boolean checkAndTag(Dog dog, LivingEntity owner) {
        if (this.canReachTarget(owner, dog.distanceToSqr((Entity)owner))) {
            dog.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    private void runAway(Dog dog, LivingEntity owner) {
        PathNavigation n = dog.getNavigation();
        double d = dog.distanceToSqr((Entity)owner);
        if (--this.tickTillLook <= 0) {
            this.dog.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.dog.getMaxHeadXRot());
            if (this.tickTillLook <= -20) {
                this.tickTillLook = 20;
            }
        }
        if (n.isDone() && dog.tickCount % 2 != 0) {
            BlockPos b0 = this.getRandomPosAwayFromOwner(dog, owner);
            n.moveTo((double)b0.getX(), (double)b0.getY(), (double)b0.getZ(), 1.0);
        }
        if (d < 9.0 && dog.tickCount % 10 == 0) {
            n.stop();
        }
        if (this.cooldownChase > 0) {
            --this.cooldownChase;
        }
        if (this.canReachTarget(owner, d) && this.cooldownChase <= 0) {
            n.stop();
            dog.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            this.ownerBeenTagged = false;
            this.cooldownChase = 30;
            this.timeLeft = 400;
        }
    }

    private BlockPos getRandomPosAwayFromOwner(Dog dog, LivingEntity owner) {
        BlockPos owner_b0 = owner.blockPosition();
        RandomSource r = dog.getRandom();
        int offSmall = 4;
        int offLarge = 20;
        int r1 = r.nextIntBetweenInclusive(-offLarge, offLarge);
        int r2 = r.nextIntBetweenInclusive(-offSmall, offSmall);
        r2 += Mth.sign((double)r2) * 16;
        int dy = r.nextIntBetweenInclusive(-2, 2);
        int dx = r1;
        int dz = r2;
        if (dog.getRandom().nextBoolean()) {
            dx = r2;
            dz = r1;
        }
        return owner_b0.offset(dx, dy, dz);
    }

    @Override
    public void onStop() {
    }

    protected boolean canReachTarget(LivingEntity target, double distanceToTargetSqr) {
        return this.getTagReachSqr(target) >= distanceToTargetSqr;
    }

    protected double getTagReachSqr(LivingEntity target) {
        return this.dog.getBbWidth() * 2.0f * this.dog.getBbWidth() * 2.0f + target.getBbWidth();
    }
}

