/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.serializers;

import doggytalents.common.entity.serializers.DogSerializer;
import doggytalents.common.item.DoggyArtifactItem;
import doggytalents.common.util.NetworkUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;

public class DoggyArtifactsSerializer
extends DogSerializer<List<DoggyArtifactItem>> {
    @Override
    public void write(FriendlyByteBuf buf, List<DoggyArtifactItem> value) {
        buf.writeInt(value.size());
        for (DoggyArtifactItem x : value) {
            NetworkUtil.writeRegistryId(buf, Registries.ITEM, x);
        }
    }

    @Override
    public List<DoggyArtifactItem> read(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<DoggyArtifactItem> list = new ArrayList<DoggyArtifactItem>(size);
        for (int i = 0; i < size; ++i) {
            Item item = (Item)NetworkUtil.readRegistryId(buf, Registries.ITEM);
            if (!(item instanceof DoggyArtifactItem)) continue;
            DoggyArtifactItem artifactItem = (DoggyArtifactItem)item;
            list.add(artifactItem);
        }
        return list;
    }

    public List<DoggyArtifactItem> copy(List<DoggyArtifactItem> value) {
        ArrayList<DoggyArtifactItem> newInst = new ArrayList<DoggyArtifactItem>(value.size());
        for (DoggyArtifactItem inst : value) {
            newInst.add(inst);
        }
        return newInst;
    }
}

