/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyItems;
import doggytalents.api.feature.DogMode;
import doggytalents.common.entity.Dog;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class ChopinRecordItem
extends Item {
    public final int EFFECT_RADIUS = 20;
    private final int length_ticks;

    public ChopinRecordItem(Item.Properties builder, int length_ticks) {
        super(builder);
        this.length_ticks = length_ticks;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        if (!level.isClientSide && blockstate.is(Blocks.JUKEBOX) && !((Boolean)blockstate.getValue((Property)JukeboxBlock.HAS_RECORD)).booleanValue()) {
            this.triggerChopinTailNearbyDogs(level, blockpos);
        }
        return super.useOn(context);
    }

    private void triggerChopinTailNearbyDogs(Level level, BlockPos pos) {
        List dogs = level.getEntitiesOfClass(Dog.class, AABB.encapsulatingFullBlocks((BlockPos)pos.offset(-20, -5, -20), (BlockPos)pos.offset(20, 5, 20)), d -> this.canDoChopinTail((Dog)d));
        for (Dog dog : dogs) {
            dog.setChopinTailFor(this.length_ticks);
        }
    }

    private boolean canDoChopinTail(Dog dog) {
        if (!dog.isDoingFine()) {
            return false;
        }
        return dog.isMode(DogMode.DOCILE, DogMode.WANDERING);
    }

    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (!stack.is(DoggyItems.MUSIC_DISC_CHOPIN_OP64_NO1.get())) {
            return;
        }
        stack.getItem().useOn(new UseOnContext(event.getEntity(), event.getHand(), event.getHitVec()));
    }
}

