/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.common.entity.misc.Piano;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class PianoItem
extends Item {
    private Supplier<EntityType<Piano>> pianoSup;

    public PianoItem(Item.Properties itemProps, Supplier<EntityType<Piano>> pianoSup) {
        super(itemProps.stacksTo(1));
        this.pianoSup = pianoSup;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (level.isClientSide || !(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        BlockState state = level.getBlockState(pos);
        BlockPos spawnAt = state.getCollisionShape((BlockGetter)level, pos).isEmpty() ? pos : pos.relative(face);
        Piano piano = (Piano)this.pianoSup.get().create((ServerLevel)level, null, spawnAt, MobSpawnType.TRIGGERED, !Objects.equals(pos, spawnAt) && face == Direction.UP, false);
        if (piano != null) {
            piano.setYRot(face.getOpposite().toYRot());
            level.addFreshEntity((Entity)piano);
        }
        if (player != null && !player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flags) {
        String desc_id = "items.doggytalents.piano_item_common.description";
        components.add((Component)Component.translatable((String)desc_id).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true))));
    }
}

