/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyAdvancementTriggers;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.DogEddibleItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SakeItem
extends DogEddibleItem {
    public SakeItem(Item.Properties itemProps) {
        super(itemProps, b -> b.stacksTo(8).craftRemainder(Items.GLASS_BOTTLE), b -> b);
    }

    @Override
    public boolean canConsume(AbstractDog dog, ItemStack stackIn, @Nullable Entity entityIn) {
        if (entityIn == null) {
            return false;
        }
        if (!(entityIn instanceof Player)) {
            return false;
        }
        Player player = (Player)entityIn;
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return false;
        }
        if (dog.getOwner() != player) {
            return false;
        }
        return !dog.isBaby() && super.canConsume(dog, stackIn, entityIn);
    }

    @Override
    public InteractionResult consume(AbstractDog dog, ItemStack stack, @Nullable Entity entityIn) {
        InteractionResult ret = super.consume(dog, stack, entityIn);
        this.mayBoostOrDrunkEntity((LivingEntity)dog, entityIn);
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            player.getCooldowns().addCooldown((Item)this, 40);
        }
        return ret;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack ret = stack;
        if (!(entity instanceof Player)) {
            return ret;
        }
        Player player = (Player)entity;
        if (!player.level().isClientSide) {
            this.mayBoostOrDrunkEntity((LivingEntity)player, null);
            player.getCooldowns().addCooldown((Item)this, 40);
        }
        if (!player.getAbilities().instabuild) {
            ret.shrink(1);
        }
        if (ret.isEmpty()) {
            return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        }
        ItemStack bonusReturnStack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        Inventory inv = player.getInventory();
        int freeSlot = inv.getFreeSlot();
        if (freeSlot >= 0) {
            inv.add(bonusReturnStack);
        } else {
            player.spawnAtLocation(bonusReturnStack);
        }
        return ret;
    }

    public InteractionResultHolder<ItemStack> use(Level p_42993_, Player p_42994_, InteractionHand p_42995_) {
        return ItemUtils.startUsingInstantly((Level)p_42993_, (Player)p_42994_, (InteractionHand)p_42995_);
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        return null;
    }

    @Override
    public SoundEvent getDogEatingSound(AbstractDog dog) {
        return SoundEvents.GENERIC_DRINK;
    }

    public UseAnim getUseAnimation(ItemStack p_41452_) {
        return UseAnim.DRINK;
    }

    public int getUseDuration(ItemStack p_41454_, LivingEntity p_344979_) {
        return 32;
    }

    @Override
    public boolean alwaysEatWhenDogConsume(AbstractDog dog) {
        return true;
    }

    @Override
    public ItemStack getReturnStackAfterDogConsume(ItemStack useStack, AbstractDog dog) {
        return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
    }

    private void mayBoostOrDrunkEntity(LivingEntity entity, @Nullable Entity feeder) {
        boolean drunk;
        float r = entity.getRandom().nextFloat();
        boolean bl = drunk = r <= 0.4f;
        if (!drunk) {
            if (!(entity instanceof Dog) && !(entity instanceof Player)) {
                return;
            }
            entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 1200, 1));
            entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 1200, 2));
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1200, 0));
            entity.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 1200, 0));
            return;
        }
        int r_drunkTicks = 20 * (30 + entity.getRandom().nextInt(15));
        if (entity instanceof Dog) {
            Dog dog = (Dog)entity;
            if (feeder instanceof ServerPlayer) {
                ServerPlayer sP = (ServerPlayer)feeder;
                DoggyAdvancementTriggers.DOG_DRUNK_TRIGGER.trigger(dog, sP);
            }
            dog.setDrunkTicks(r_drunkTicks);
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            r_drunkTicks = 1200;
            if (player.getRandom().nextBoolean()) {
                r_drunkTicks *= 2;
            }
            player.removeEffect(MobEffects.MOVEMENT_SPEED);
            player.addEffect(new MobEffectInstance(MobEffects.CONFUSION, r_drunkTicks, 2));
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, r_drunkTicks, 3));
            player.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, r_drunkTicks, 1));
            player.addEffect(new MobEffectInstance(MobEffects.DARKNESS, r_drunkTicks, 3));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flags) {
        String desc_id = this.getDescriptionId(stack) + ".description";
        components.add((Component)Component.translatable((String)desc_id).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true))));
    }
}

