/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.api.registry.AccessoryInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.AccessoryItem;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.ChangeAccessoriesData;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ChangeAccessoryPacket
extends DogPacket<ChangeAccessoriesData> {
    @Override
    public void encode(ChangeAccessoriesData data, FriendlyByteBuf buf) {
        buf.writeInt(data.entityId);
        buf.writeBoolean(data.add);
        buf.writeBoolean(data.wolfArmorSlot);
        buf.writeInt(data.slotId);
    }

    @Override
    public ChangeAccessoriesData decode(FriendlyByteBuf buf) {
        int dog_id = buf.readInt();
        boolean add = buf.readBoolean();
        boolean wolf_armor = buf.readBoolean();
        int slot_id = buf.readInt();
        return new ChangeAccessoriesData(dog_id, add, slot_id, wolf_armor);
    }

    @Override
    public void handleDog(Dog dog, ChangeAccessoriesData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        ServerPlayer sender = ctx.get().getSender();
        if (!dog.canInteract((LivingEntity)sender)) {
            return;
        }
        if (data.add) {
            Inventory inventory = sender.getInventory();
            NonNullList items = inventory.items;
            if (data.slotId >= items.size()) {
                return;
            }
            ItemStack item = (ItemStack)items.get(data.slotId);
            Item item2 = item.getItem();
            if (item2 instanceof AccessoryItem) {
                AccessoryItem accessoryItem = (AccessoryItem)item2;
                AccessoryInstance inst = accessoryItem.createInstance(dog, item, (Player)sender);
                if (inst == null) {
                    return;
                }
                if (dog.addAccessory(inst)) {
                    dog.consumeItemFromStack((Entity)dog, item);
                }
            } else if (item.getItem() == Items.WOLF_ARMOR) {
                ChangeAccessoryPacket.handleSetWolfArmor(sender, dog, item);
            }
        } else {
            if (data.wolfArmorSlot) {
                ChangeAccessoryPacket.handleUnsetWolfArmor(sender, dog, data);
                return;
            }
            List<AccessoryInstance> accessories = dog.getAccessories();
            if (data.slotId >= accessories.size()) {
                return;
            }
            AccessoryInstance toRemove = accessories.get(data.slotId);
            if (toRemove == null) {
                return;
            }
            Inventory inventory = sender.getInventory();
            ItemStack retItem = toRemove.getReturnItem();
            if (retItem == null) {
                return;
            }
            if (inventory.getFreeSlot() < 0) {
                return;
            }
            inventory.add(toRemove.getReturnItem());
            dog.dogSyncedDataManager.accessories().remove(data.slotId);
            dog.dogSyncedDataManager.setAccessoriesDirty();
        }
    }

    private static void handleSetWolfArmor(ServerPlayer sender, Dog dog, ItemStack toConsume) {
        if (dog.hasWolfArmor()) {
            return;
        }
        if (!toConsume.is(Items.WOLF_ARMOR)) {
            return;
        }
        dog.setWolfArmor(toConsume.copyWithCount(1));
        dog.consumeItemFromStack((Entity)dog, toConsume);
    }

    private static void handleUnsetWolfArmor(ServerPlayer sender, Dog dog, ChangeAccessoriesData data) {
        if (!dog.hasWolfArmor()) {
            return;
        }
        Inventory inventory = sender.getInventory();
        if (inventory.getFreeSlot() < 0) {
            return;
        }
        dog.playSound(SoundEvents.ARMOR_UNEQUIP_WOLF);
        ItemStack wolf_armor0 = dog.wolfArmor();
        dog.setWolfArmor(ItemStack.EMPTY);
        inventory.add(wolf_armor0.copyWithCount(1));
    }
}

