/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.api.feature.DogMode;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogModeData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;

public class DogModePacket
extends DogPacket<DogModeData> {
    @Override
    public void encode(DogModeData data, FriendlyByteBuf buf) {
        super.encode(data, buf);
        buf.writeInt(data.mode.getIndex());
    }

    @Override
    public DogModeData decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        int modeIndex = buf.readInt();
        return new DogModeData(entityId, DogMode.byIndex(modeIndex));
    }

    @Override
    public void handleDog(Dog dogIn, DogModeData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        if (!dogIn.canInteract((LivingEntity)ctx.get().getSender())) {
            return;
        }
        dogIn.setMode(data.mode);
    }
}

