/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.entity.Dog;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.DogData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;

public abstract class DogPacket<T extends DogData>
implements IPacket<T> {
    @Override
    public void encode(T data, FriendlyByteBuf buf) {
        buf.writeInt(((DogData)data).entityId);
    }

    @Override
    public abstract T decode(FriendlyByteBuf var1);

    @Override
    public final void handle(T data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity target = ((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).getSender().level().getEntity(data.entityId);
            if (!(target instanceof Dog)) {
                return;
            }
            this.handleDog((Dog)target, data, ctx);
        });
        ctx.get().setPacketHandled(true);
    }

    public abstract void handleDog(Dog var1, T var2, Supplier<DTNNetworkHandler.NetworkEvent.Context> var3);
}

