/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.DoggySounds;
import doggytalents.api.feature.DogMode;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.DogSoftHeelAction;
import doggytalents.common.item.WhistleItem;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.HeelByNameData;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.ItemUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class HeelByNamePacket
extends DogPacket<HeelByNameData> {
    @Override
    public void encode(HeelByNameData data, FriendlyByteBuf buf) {
        buf.writeInt(data.entityId);
        buf.writeBoolean(data.heelAndSit);
        buf.writeBoolean(data.softHeel);
    }

    @Override
    public HeelByNameData decode(FriendlyByteBuf buf) {
        return new HeelByNameData(buf.readInt(), buf.readBoolean(), buf.readBoolean());
    }

    @Override
    public void handleDog(Dog dog, HeelByNameData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        ServerPlayer owner = ctx.get().getSender();
        if (!dog.canInteract((LivingEntity)owner)) {
            return;
        }
        if (owner.getCooldowns().isOnCooldown((Item)DoggyItems.WHISTLE.get())) {
            return;
        }
        if (dog.isPassenger()) {
            dog.stopRiding();
        }
        dog.clearTriggerableAction();
        DogMode mode = dog.getMode();
        if (mode.canWander()) {
            dog.setMode(mode.shouldAttack() ? DogMode.AGGRESIVE : DogMode.DOCILE);
        }
        if (data.softHeel) {
            if (dog.readyForNonTrivialAction()) {
                dog.triggerAction(new DogSoftHeelAction(dog, (LivingEntity)owner));
            }
        } else {
            dog.setOrderedToSit(data.heelAndSit);
            DogUtil.dynamicSearchAndTeleportToOwnwer(dog, (LivingEntity)owner, 2);
        }
        owner.level().playSound(null, owner.blockPosition(), DoggySounds.WHISTLE_LONG.get(), SoundSource.PLAYERS, 0.6f + owner.level().random.nextFloat() * 0.1f, 0.4f + owner.level().random.nextFloat() * 0.2f);
        owner.sendSystemMessage((Component)Component.translatable((String)"dogcommand.heel_by_name", (Object[])new Object[]{dog.getName().getString()}));
        owner.getCooldowns().addCooldown((Item)DoggyItems.WHISTLE.get(), 20);
        ItemStack stack = owner.getMainHandItem();
        if (stack.getItem() instanceof WhistleItem) {
            ItemUtil.modifyTag(stack, to_modify -> to_modify.putBoolean("soft_heel", data.softHeel));
        }
    }
}

