/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.entity.Dog;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.PatrolTargetLockData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;

public class PatrolTargetLockPacket
extends DogPacket<PatrolTargetLockData> {
    @Override
    public void encode(PatrolTargetLockData data, FriendlyByteBuf buf) {
        super.encode(data, buf);
        buf.writeBoolean(data.val);
    }

    @Override
    public PatrolTargetLockData decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        boolean val = buf.readBoolean();
        return new PatrolTargetLockData(entityId, val);
    }

    @Override
    public void handleDog(Dog dogIn, PatrolTargetLockData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        if (!dogIn.canInteract((LivingEntity)ctx.get().getSender())) {
            return;
        }
        dogIn.setPatrolTargetLock(data.val);
    }
}

