/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.WhistleItem;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.WhistleUseData;
import doggytalents.common.util.InventoryUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WhistleUsePacket
implements IPacket<WhistleUseData> {
    @Override
    public void encode(WhistleUseData data, FriendlyByteBuf buf) {
        buf.writeInt(data.mode_id);
    }

    @Override
    public WhistleUseData decode(FriendlyByteBuf buf) {
        return new WhistleUseData(buf.readInt());
    }

    @Override
    public void handle(WhistleUseData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            WhistleItem whistle;
            if (!((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isServerRecipent()) {
                return;
            }
            ServerPlayer player = ((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
            ItemStack whistle_stack = InventoryUtil.findStackWithItemFromHands((Player)player, whistle = DoggyItems.WHISTLE.get());
            if (whistle_stack == null) {
                return;
            }
            if (player.getCooldowns().isOnCooldown((Item)whistle)) {
                return;
            }
            WhistleItem.WhistleMode[] whistle_modes = WhistleItem.WhistleMode.VALUES;
            if (data.mode_id >= whistle_modes.length) {
                return;
            }
            if (data.mode_id < 0) {
                return;
            }
            WhistleItem.WhistleMode useMode = whistle_modes[data.mode_id];
            List dogsList = player.level().getEntitiesOfClass(Dog.class, player.getBoundingBox().inflate(100.0, 50.0, 100.0), dog -> dog.isDoingFine() && dog.isOwnedBy((LivingEntity)player));
            whistle.useMode(useMode, WhistleItem.isDogOnDutyOnly(whistle_stack), dogsList, player.level(), (Player)player, InteractionHand.MAIN_HAND, true);
        });
        ctx.get().setPacketHandled(true);
    }
}

