/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.storage;

import com.google.common.collect.Maps;
import doggytalents.DoggyTalentsNext;
import doggytalents.common.entity.Dog;
import doggytalents.common.storage.DogRespawnData;
import doggytalents.common.util.NBTUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class DogRespawnStorage
extends SavedData {
    private Map<UUID, DogRespawnData> respawnDataMap = Maps.newHashMap();
    private static SavedData.Factory<DogRespawnStorage> FACTORY = new SavedData.Factory(DogRespawnStorage::new, DogRespawnStorage::load);

    public static DogRespawnStorage get(Level world) {
        if (!(world instanceof ServerLevel)) {
            throw new IllegalStateException("DogRespawnStorage is being accessed from the Client Side. Please report to the DTN Team.");
        }
        ServerLevel overworld = world.getServer().getLevel(Level.OVERWORLD);
        DimensionDataStorage storage = overworld.getDataStorage();
        return (DogRespawnStorage)storage.computeIfAbsent(DogRespawnStorage.storageFactory(), "doggytalentsDeadDogs");
    }

    public static DogRespawnStorage get(MinecraftServer server) {
        ServerLevel overworld = server.getLevel(Level.OVERWORLD);
        DimensionDataStorage storage = overworld.getDataStorage();
        return (DogRespawnStorage)storage.computeIfAbsent(DogRespawnStorage.storageFactory(), "doggytalentsDeadDogs");
    }

    public Stream<DogRespawnData> getDogs(@Nonnull UUID ownerId) {
        return this.respawnDataMap.values().stream().filter(data -> ownerId.equals(data.getOwnerId()));
    }

    @Nullable
    public DogRespawnData getData(UUID uuid) {
        if (this.respawnDataMap.containsKey(uuid)) {
            return this.respawnDataMap.get(uuid);
        }
        return null;
    }

    @Nullable
    public DogRespawnData remove(UUID uuid) {
        if (this.respawnDataMap.containsKey(uuid)) {
            DogRespawnData storage = this.respawnDataMap.remove(uuid);
            this.setDirty();
            return storage;
        }
        return null;
    }

    @Nullable
    public DogRespawnData putData(Dog dogIn) {
        UUID uuid = dogIn.getUUID();
        DogRespawnData storage = new DogRespawnData(this, uuid);
        storage.populate(dogIn);
        this.respawnDataMap.put(uuid, storage);
        this.setDirty();
        return storage;
    }

    public Set<UUID> getAllUUID() {
        return Collections.unmodifiableSet(this.respawnDataMap.keySet());
    }

    public Collection<DogRespawnData> getAll() {
        return Collections.unmodifiableCollection(this.respawnDataMap.values());
    }

    public static DogRespawnStorage load(CompoundTag nbt, HolderLookup.Provider prov) {
        DogRespawnStorage store = new DogRespawnStorage();
        store.respawnDataMap.clear();
        ListTag list = nbt.getList("respawnData", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag respawnCompound = list.getCompound(i);
            UUID uuid = NBTUtil.getUniqueId(respawnCompound, "uuid");
            DogRespawnData respawnData = new DogRespawnData(store, uuid);
            respawnData.read(respawnCompound);
            if (uuid == null) {
                DoggyTalentsNext.LOGGER.info("Failed to load dog respawn data. Please report to mod author...");
                DoggyTalentsNext.LOGGER.info((Object)respawnData);
                continue;
            }
            store.respawnDataMap.put(uuid, respawnData);
        }
        return store;
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider prov) {
        ListTag list = new ListTag();
        for (Map.Entry<UUID, DogRespawnData> entry : this.respawnDataMap.entrySet()) {
            CompoundTag respawnCompound = new CompoundTag();
            DogRespawnData respawnData = entry.getValue();
            NBTUtil.putUniqueId(respawnCompound, "uuid", entry.getKey());
            respawnData.write(respawnCompound);
            list.add((Object)respawnCompound);
        }
        compound.put("respawnData", (Tag)list);
        return compound;
    }

    public static SavedData.Factory<DogRespawnStorage> storageFactory() {
        return FACTORY;
    }
}

