/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyTags;
import doggytalents.DoggyTalents;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.ObjectUtils;

public class MobRetrieverTalent
extends TalentInstance {
    private LivingEntity targetEntity;

    public MobRetrieverTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void tick(AbstractDog dogIn) {
        if (dogIn.level().isClientSide) {
            return;
        }
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        this.updateRidingPassanger(dog);
        this.updateAndSetRetrieveTarget(dog);
    }

    private void updateRidingPassanger(Dog dog) {
        Entity riding = dog.getFirstPassenger();
        if (riding == null) {
            return;
        }
        if (riding instanceof Player) {
            return;
        }
        if (!this.canStillRideTarget(dog, riding)) {
            dog.unRide();
        }
    }

    private void updateAndSetRetrieveTarget(Dog dog) {
        if (this.targetEntity == null) {
            return;
        }
        LivingEntity target = this.targetEntity;
        this.targetEntity = null;
        if (!this.isValidTarget(dog, target)) {
            return;
        }
        if (dog.isBusy() || !this.readyForNewRider(dog)) {
            return;
        }
        if (dog.isOrderedToSit()) {
            return;
        }
        dog.triggerAction(new DogRetrieveMobAction(dog, target, this));
    }

    @Override
    public void set(AbstractDog dog, int levelBefore) {
        if (dog.level().isClientSide) {
            return;
        }
        if (levelBefore > 0 && this.level() <= 0) {
            dog.unRide();
        }
    }

    public boolean isValidTarget(Dog dog, LivingEntity target) {
        TamableAnimal otherDog;
        if (target == dog) {
            return false;
        }
        if (target.distanceToSqr((Entity)dog) >= (double)(MobRetrieverTalent.getSelectTargetRange() * MobRetrieverTalent.getSelectTargetRange())) {
            return false;
        }
        if (!target.isAlive()) {
            return false;
        }
        if (target.isSpectator()) {
            return false;
        }
        if (target.isVehicle()) {
            return false;
        }
        boolean onlyDog = (Boolean)ConfigHandler.SERVER.MOB_RETRIEVER_ONLY_CARRY_DOG.get();
        boolean onlyLeashable = (Boolean)ConfigHandler.SERVER.MOB_RETRIEVER_ONLY_CARRY_LEASHABLE.get();
        if (onlyDog && !(target instanceof Dog)) {
            return false;
        }
        if (!(target instanceof Mob)) {
            return false;
        }
        if (onlyLeashable && !((Mob)target).canBeLeashed()) {
            return false;
        }
        if (target instanceof Player) {
            return false;
        }
        if (target instanceof Enemy) {
            return false;
        }
        if (target.getType().is(DoggyTags.MOB_RETRIEVER_MUST_IGNORE)) {
            return false;
        }
        if (target instanceof TamableAnimal && (otherDog = (TamableAnimal)target).getOwnerUUID() != null && ObjectUtils.notEqual((Object)otherDog.getOwnerUUID(), (Object)dog.getOwnerUUID())) {
            return false;
        }
        return this.canLevelRideTarget(dog, (Entity)target);
    }

    private boolean canStillRideTarget(Dog dog, Entity target) {
        if (!target.isAlive()) {
            return false;
        }
        if (target.isSpectator()) {
            return false;
        }
        if (target.isVehicle()) {
            return false;
        }
        boolean onlyDog = (Boolean)ConfigHandler.SERVER.MOB_RETRIEVER_ONLY_CARRY_DOG.get();
        if (onlyDog && !(target instanceof Dog)) {
            return false;
        }
        if (dog.isInSittingPose()) {
            return false;
        }
        if (!dog.isDoingFine()) {
            return false;
        }
        if (!(target instanceof Mob)) {
            return false;
        }
        if (target instanceof Enemy) {
            return false;
        }
        if (target.getType().is(DoggyTags.MOB_RETRIEVER_MUST_IGNORE)) {
            return false;
        }
        if (target instanceof TamableAnimal) {
            TamableAnimal otherDog = (TamableAnimal)target;
            if (dog.getOwnerUUID() != null && ObjectUtils.notEqual((Object)otherDog.getOwnerUUID(), (Object)dog.getOwnerUUID())) {
                return false;
            }
        }
        return this.canLevelRideTarget(dog, target);
    }

    @Override
    public InteractionResultHolder<Float> gettingAttackedFrom(AbstractDog dog, DamageSource source, float damage) {
        if (!dog.level().isClientSide) {
            this.maybeDropRiding(dog);
        }
        return super.gettingAttackedFrom(dog, source, damage);
    }

    private void maybeDropRiding(AbstractDog dog) {
        TamableAnimal otherDog;
        if (!dog.isVehicle()) {
            return;
        }
        Entity passenger = dog.getFirstPassenger();
        if (passenger == null) {
            return;
        }
        if (passenger instanceof Player) {
            return;
        }
        if (passenger instanceof TamableAnimal && (otherDog = (TamableAnimal)passenger).getOwner() == dog.getOwner()) {
            return;
        }
        dog.unRide();
    }

    private boolean canLevelRideTarget(Dog dog, Entity target) {
        int lvl = this.level();
        float target_bbW = target.getBbWidth();
        float target_bbH = target.getBbHeight();
        float w_ratio = target_bbW / dog.getDogVisualBbWidth();
        float h_ratio = target_bbH / dog.getDogVisualBbHeight();
        if (target_bbW >= 1.0f) {
            return false;
        }
        if ((double)w_ratio > 1.2) {
            return false;
        }
        if (lvl >= 5) {
            return h_ratio <= 2.0f;
        }
        if (lvl >= 3) {
            return (double)h_ratio <= 1.5;
        }
        return h_ratio <= 1.0f;
    }

    private boolean readyForNewRider(Dog dog) {
        return dog.isDoingFine() && !dog.isInSittingPose() && !dog.isVehicle();
    }

    public void setTarget(Dog dog, LivingEntity target) {
        if (!this.isValidTarget(dog, target)) {
            return;
        }
        this.targetEntity = target;
    }

    public static Optional<Dog> chooseNearestDog(Player player, Level level) {
        List valid_dogs = level.getEntitiesOfClass(Dog.class, player.getBoundingBox().inflate(4.0, 2.0, 4.0), d -> {
            if (!d.isDoingFine()) {
                return false;
            }
            if (d.getDogLevel(DoggyTalents.MOB_RETRIEVER) <= 0) {
                return false;
            }
            return !d.isBusy();
        });
        if (valid_dogs.isEmpty()) {
            return Optional.empty();
        }
        double min_dist = ((Dog)valid_dogs.get(0)).distanceToSqr((Entity)player);
        Dog choosen_dog = (Dog)valid_dogs.get(0);
        for (Dog dog : valid_dogs) {
            double dist = dog.distanceToSqr((Entity)player);
            if (!(dist < min_dist)) continue;
            min_dist = dist;
            choosen_dog = dog;
        }
        return Optional.of(choosen_dog);
    }

    @Override
    public InteractionResult blockIdleAnim(AbstractDog dogIn) {
        if (dogIn.isVehicle()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static int getSelectTargetRange() {
        return 20;
    }

    public static class DogRetrieveMobAction
    extends TriggerableAction {
        private MobRetrieverTalent inst;
        private LivingEntity target;
        private int tickTillPathRecalc;
        private int stopDist = 3;
        private boolean isBringingBack = false;
        private LivingEntity owner = null;

        public DogRetrieveMobAction(Dog dog, LivingEntity target, MobRetrieverTalent inst) {
            super(dog, false, false);
            this.target = target;
            this.inst = inst;
        }

        @Override
        public void onStart() {
        }

        @Override
        public void tick() {
            if (!this.inst.isValidTarget(this.dog, this.target)) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (!this.isBringingBack && !this.dog.getPassengers().isEmpty()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.isBringingBack && this.dog.getPassengers().isEmpty()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.isBringingBack && this.owner == null) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.isBringingBack && (!this.ownerIsStillThere() || this.returnedToOwner())) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.isBringingBack) {
                this.returnToOwner();
            } else {
                this.goGetMob();
            }
        }

        private void goGetMob() {
            if (this.dog.distanceToSqr((Entity)this.target) > (double)(this.stopDist * this.stopDist)) {
                this.dog.getLookControl().setLookAt((Entity)this.target, 10.0f, (float)this.dog.getMaxHeadXRot());
                if (--this.tickTillPathRecalc <= 0) {
                    this.tickTillPathRecalc = 10;
                    if (!this.dog.isLeashed() && !this.dog.isPassenger()) {
                        this.dog.getNavigation().moveTo((Entity)this.target, (double)this.dog.getUrgentSpeedModifier());
                    }
                }
            } else {
                this.dog.getNavigation().stop();
                this.target.startRiding((Entity)this.dog);
                this.owner = this.dog.getOwner();
                this.isBringingBack = true;
            }
        }

        private void returnToOwner() {
            if (this.dog.distanceToSqr((Entity)this.owner) > (double)(this.stopDist * this.stopDist)) {
                this.dog.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.dog.getMaxHeadXRot());
                if (--this.tickTillPathRecalc <= 0) {
                    this.tickTillPathRecalc = 10;
                    if (!this.dog.isLeashed() && !this.dog.isPassenger()) {
                        this.dog.getNavigation().moveTo((Entity)this.owner, (double)this.dog.getUrgentSpeedModifier());
                    }
                }
            }
        }

        @Override
        public void onStop() {
        }

        private boolean ownerIsStillThere() {
            if (!this.owner.isAlive()) {
                return false;
            }
            if (this.owner.isSpectator()) {
                return false;
            }
            return !(this.owner.distanceToSqr((Entity)this.dog) > 256.0);
        }

        private boolean returnedToOwner() {
            return this.dog.distanceToSqr((Entity)this.owner) <= (double)(this.stopDist * this.stopDist);
        }
    }
}

